/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.util.JavaVersion;
import de.dal33t.powerfolder.util.os.OSUtil;

public class Constants {
    public static final String POWERFOLDER_HOMEPAGE = "https://www.powerfolder.com";
    public static final String POWERFOLDER_SYSTEM_SUBDIR = System.getProperty("pf.syssubdir", ".PowerFolder");
    public static final String DEFAULT_CONFIG_FILE = System.getProperty("pf.defconfig", "PowerFolder.config");
    public static final String MISC_DIR_NAME = System.getProperty("pf.configdir", "PowerFolder");
    public static final String DB_FILENAME = System.getProperty("pf.dbfilename", ".PowerFolder.db");
    public static final String DB_BACKUP_FILENAME = DB_FILENAME + ".bak";
    public static final String METAFOLDER_SUBDIR = "meta";
    public static final String SYSTEM_SUBDIR = "foldermeta";
    public static final String METAFOLDER_ID_PREFIX = "meta|";
    public static String FOLDERS_BASE_DIR_SUBDIR_NAME = "PowerFolders";
    public static final String GETTING_STARTED_GUIDE_FILENAME = "Getting started.pdf";
    public static final String ATOMIC_COMMIT_TEMP_TARGET_DIR = ".temp-dir";
    public static final String LIMITED_CONNECTIVITY_CHECK_URL = "http://checkconnectivity.powerfolder.com/check.php";
    public static final int UPDATE_CHECK_PERIOD_MINUTES = 60;
    public static final int CONTROLLER_MIN_THREADS_IN_THREADPOOL;
    public static final int UI_DEFAULT_SCREEN_BORDER = 50;
    public static final boolean OPACITY_SUPPORTED;
    public static final String NETWORK_ID_ANY = "ANY";
    public static final int FILE_LIST_MAX_FILES_PER_MESSAGE = 500;
    public static final int N_SUPERNODES_TO_CONNECT = 3;
    public static final int N_SUPERNODES_TO_CONTACT_FOR_NODE_SEARCH = 4;
    public static final int N_LAN_NODES_TO_CONTACT_FOR_NODE_SEARCH = 4;
    public static final int N_SUPERNODES_TO_CONTACT_FOR_NODE_LIST = 4;
    public static final int NODE_LIST_REQUEST_INTERVAL = 480;
    public static final int TRANSFER_STATUS_BROADCAST_INTERVAL = 600;
    public static final long NODES_THAN_WENT_ONLINE_BROADCAST_TIME = 60L;
    public static final int NODES_LIST_MAX_NODES_PER_MESSAGE = 500;
    public static final double MAX_NODES_CONNECTIONS_PER_KBS_UPLOAD = 1.0;
    public static final long MAX_NODE_OFFLINE_TIME = 36000000L;
    public static final long NODE_TIME_TO_INVALIDATE = 5184000000L;
    public static final long NODE_TIME_TO_REMOVE_MEMBER = 1296000000L;
    public static final long NODE_TIME_MAX_IN_FUTURE = 86400000L;
    public static final int MIN_NUMBER_RECONNECTORS = 2;
    public static final int MAX_NUMBER_RECONNECTORS = 5;
    public static final int WARN_MESSAGES_IN_SEND_QUEUE = 1998;
    public static final int MAX_MESSAGES_IN_SEND_QUEUE = 2000;
    public static final long LIMITED_CONNECTIVITY_CHECK_DELAY = 30L;
    public static final long FOLDER_UNSYNCED_CHECK_DELAY = 120L;
    public static final long HOSTING_FOLDERS_REQUEST_INTERVAL = 600L;
    public static final long REQUEST_RESPONSE_TIMEOUT = 60L;
    public static final int SOCKET_CONNECT_TIMEOUT = 30000;
    public static final int MAX_INCOMING_CONNECTIONS = 100;
    public static final long INCOMING_CONNECTION_CHECK_TIME = 60L;
    public static final long CONNECTION_KEEP_ALIVE_TIMEOUT = 120L;
    public static final long RECONNECTOR_POOL_SIZE_RESIZE_TIME = 120L;
    public static final int MAX_PENDING_UDT_CONNECTIONS = 10;
    public static final long TO_UDT_CONNECTION = 30000L;
    public static final int MAX_DLS_FROM_INET_MEMBER = 20;
    public static final long START_UPLOADS_TILL_PLANNED_SIZE_INET = 0x200000L;
    public static final int MAX_DLS_FROM_LAN_MEMBER = 50;
    public static final long START_UPLOADS_TILL_PLANNED_SIZE_LAN = 0xA00000L;
    public static final long DOWNLOAD_REQUEST_TIMEOUT_LIMIT = 180000L;
    public static final long UPLOAD_REQUEST_TIMEOUT = 180000L;
    public static final long UPLOAD_REMOTEHASHING_PART_REQUEST_TIMEOUT = 18000000L;
    public static final long DELTA_SYNC_MIN_FILESIZE = 51200L;
    public static final int MIN_SIZE_FOR_PARTTRANSFERS = 8192;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final String FOLDER_ENCRYPTION_SUFFIX = ".crypto";
    public static final String FOLDER_ENCRYPTED_CONTAINER_ROOT_DIR = "/encDir";
    public static final String FOLDER_WEBDAV_SUFFIX = ".webdav";
    public static final String FOLDER_WEBDAV_HTTP_PREFIX = "http";
    public static final String PACKAGE_PREFIX = "de.dal33t.powerfolder.";
    public static final String PRO_LOADER_PLUGIN_CLASS = "CD";
    public static final String ENCRYPTION_PLUGIN_CLASS = "BC";
    public static final String UI_LOCK_UNLOCK_URI = "/unlock";
    public static final String LOGIN_URI = "/login";
    public static final String REGISTER_URI = "/register";
    public static final String CHECK_MAILS_URI = "/check_mails";
    public static final String ACTIVATE_URI = "/activate";
    public static final String GET_LINK_URI = "/getlink";
    public static final String DL_LINK_URI = "/dl";
    public static final String DL_LINK_ENTER_PW_URI = "/dlpw";
    public static final String OPEN_LINK_URI = "/open";
    public static final String LOGIN_SHIBBOLETH_URI = "/login/shibboleth";
    public static final String LOGIN_SHIBBOLETH_CLIENT_URI = "/login/shibboleth/client";
    @Deprecated
    public static final String LOGIN_SHIBBOLETH_ANDROID_URI = "/login/shibboleth/android";
    @Deprecated
    public static final String LOGIN_SHIBBOLETH_IOS_URI = "/login/shibboleth/ios";
    public static final String LOGIN_SHIBBOLETH_BROWSER_URI = "/login/shibboleth/browser";
    public static final String WEBSOCKET_CLIENT_URI = "/websocket_client";
    public static final String WEBDAV_URI = "/webdav";
    public static final String LOGIN_PARAM_USERNAME = "Username";
    public static final String LOGIN_PARAM_KEEP_LOGGED = "KeepLoggedIn";
    public static final String LOGIN_PARAM_PASSWORD = "Password";
    public static final String LOGIN_PARAM_TOTP_CODE = "Totp";
    public static final String LOGIN_PARAM_PASSWORD_OBF = "PasswordOBF";
    public static final String LOGIN_PARAM_OR_HEADER_TOKEN = "Token";
    public static final String LOGIN_PARAM_OR_HEADER_TOKEN_BEARER = "Bearer";
    public static final String LOGIN_PARAM_ORIGINAL_URI = "originalURI";
    public static final String MY_ACCOUNT_URI = "/myaccount";
    public static final String OAUTH_IDENTIFIER = "oauth";
    public static final int[] CLEANUP_VALUES;
    public static final int DEFAULT_NORMAL_DOCKED_WIDTH = 1100;
    public static final int DEFAULT_NORMAL_HEIGHT = 600;
    public static final String LINK_EXTENSION = ".lnk";
    public static final String FOLDER_PERSONAL_FILES = "$personal_files";
    public static final String FOLDER_PUBLIC_SHARED_FILES = "$public_shared_files";
    public static final String MAIL_ATTACHMENT_FOLDER = "$mail_attachments";
    public static final String MS_OFFICE_FILENAME_PREFIX = "~$";
    public static final String LIBRE_OFFICE_FILENAME_PREFIX = ".~lock.";

    private Constants() {
    }

    static {
        int n = 3;
        try {
            n = Integer.valueOf(System.getProperty("pf.controller.threadpool.min.size", String.valueOf(n)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CONTROLLER_MIN_THREADS_IN_THREADPOOL = n;
        OPACITY_SUPPORTED = !OSUtil.isLinux() && JavaVersion.systemVersion().compareTo(new JavaVersion(1, 6, 0, 10, 12)) >= 0;
        CLEANUP_VALUES = new int[]{0, 1, 10, 30, Integer.MAX_VALUE};
    }
}

