/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentMonitor;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;

public final class Monitors {
    private static final Logger logger = Logger.getLogger(Monitors.class.getName());
    private static final Provider<ProductionComponentMonitor> NO_OP_PRODUCTION_COMPONENT_MONITOR_PROVIDER = new Provider<ProductionComponentMonitor>(){

        @Override
        public ProductionComponentMonitor get() {
            return ProductionComponentMonitor.noOp();
        }
    };

    public static ProductionComponentMonitor.Factory delegatingProductionComponentMonitorFactory(Collection<? extends ProductionComponentMonitor.Factory> collection) {
        if (collection.isEmpty()) {
            return ProductionComponentMonitor.Factory.noOp();
        }
        if (collection.size() == 1) {
            return new NonThrowingProductionComponentMonitor.Factory(Iterables.getOnlyElement(collection));
        }
        return new DelegatingProductionComponentMonitor.Factory(collection);
    }

    public static ProductionComponentMonitor createMonitorForComponent(Provider<?> provider, Provider<Set<ProductionComponentMonitor.Factory>> provider2) {
        try {
            ProductionComponentMonitor.Factory factory = Monitors.delegatingProductionComponentMonitorFactory((Collection<? extends ProductionComponentMonitor.Factory>)provider2.get());
            return factory.create(provider.get());
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.SEVERE, "RuntimeException while constructing monitor factories.", runtimeException);
            return ProductionComponentMonitor.noOp();
        }
    }

    public static Provider<ProductionComponentMonitor> noOpProductionComponentMonitorProvider() {
        return NO_OP_PRODUCTION_COMPONENT_MONITOR_PROVIDER;
    }

    private static void logCreateException(RuntimeException runtimeException, ProductionComponentMonitor.Factory factory, Object object) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProductionComponentMonitor.Factory.create on factory " + factory + " with component " + object, runtimeException);
    }

    private static void logProducerMonitorForException(RuntimeException runtimeException, ProductionComponentMonitor productionComponentMonitor, ProducerToken producerToken) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProductionComponentMonitor.producerMonitorFor on monitor " + productionComponentMonitor + " with token " + producerToken, runtimeException);
    }

    private static void logProducerMonitorMethodException(RuntimeException runtimeException, ProducerMonitor producerMonitor, String string) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProducerMonitor." + string + " on monitor " + producerMonitor, runtimeException);
    }

    private static void logProducerMonitorArgMethodException(RuntimeException runtimeException, ProducerMonitor producerMonitor, String string, Object object) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProducerMonitor." + string + " on monitor " + producerMonitor + " with " + object, runtimeException);
    }

    private Monitors() {
    }

    private static final class DelegatingProducerMonitor
    extends ProducerMonitor {
        private final ImmutableList<ProducerMonitor> delegates;

        DelegatingProducerMonitor(ImmutableList<ProducerMonitor> immutableList) {
            this.delegates = immutableList;
        }

        @Override
        public void requested() {
            for (ProducerMonitor producerMonitor : this.delegates) {
                try {
                    producerMonitor.requested();
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorMethodException(runtimeException, producerMonitor, "requested");
                }
            }
        }

        @Override
        public void ready() {
            for (ProducerMonitor producerMonitor : this.delegates) {
                try {
                    producerMonitor.ready();
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorMethodException(runtimeException, producerMonitor, "ready");
                }
            }
        }

        @Override
        public void methodStarting() {
            for (ProducerMonitor producerMonitor : this.delegates) {
                try {
                    producerMonitor.methodStarting();
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorMethodException(runtimeException, producerMonitor, "methodStarting");
                }
            }
        }

        @Override
        public void methodFinished() {
            for (ProducerMonitor producerMonitor : this.delegates.reverse()) {
                try {
                    producerMonitor.methodFinished();
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorMethodException(runtimeException, producerMonitor, "methodFinished");
                }
            }
        }

        @Override
        public void succeeded(Object object) {
            for (ProducerMonitor producerMonitor : this.delegates.reverse()) {
                try {
                    producerMonitor.succeeded(object);
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorArgMethodException(runtimeException, producerMonitor, "succeeded", object);
                }
            }
        }

        @Override
        public void failed(Throwable throwable) {
            for (ProducerMonitor producerMonitor : this.delegates.reverse()) {
                try {
                    producerMonitor.failed(throwable);
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorArgMethodException(runtimeException, producerMonitor, "failed", throwable);
                }
            }
        }
    }

    private static final class DelegatingProductionComponentMonitor
    extends ProductionComponentMonitor {
        private final ImmutableList<ProductionComponentMonitor> delegates;

        DelegatingProductionComponentMonitor(ImmutableList<ProductionComponentMonitor> immutableList) {
            this.delegates = immutableList;
        }

        @Override
        public ProducerMonitor producerMonitorFor(ProducerToken producerToken) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ProductionComponentMonitor productionComponentMonitor : this.delegates) {
                try {
                    ProducerMonitor producerMonitor = productionComponentMonitor.producerMonitorFor(producerToken);
                    if (producerMonitor == null) continue;
                    builder.add(producerMonitor);
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logProducerMonitorForException(runtimeException, productionComponentMonitor, producerToken);
                }
            }
            ImmutableCollection immutableCollection = builder.build();
            if (immutableCollection.isEmpty()) {
                return ProducerMonitor.noOp();
            }
            if (immutableCollection.size() == 1) {
                return new NonThrowingProducerMonitor((ProducerMonitor)Iterables.getOnlyElement(immutableCollection));
            }
            return new DelegatingProducerMonitor((ImmutableList<ProducerMonitor>)immutableCollection);
        }

        static final class Factory
        extends ProductionComponentMonitor.Factory {
            private final ImmutableList<? extends ProductionComponentMonitor.Factory> delegates;

            Factory(Iterable<? extends ProductionComponentMonitor.Factory> iterable) {
                this.delegates = ImmutableList.copyOf(iterable);
            }

            @Override
            public ProductionComponentMonitor create(Object object) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ProductionComponentMonitor.Factory factory : this.delegates) {
                    try {
                        ProductionComponentMonitor productionComponentMonitor = factory.create(object);
                        if (productionComponentMonitor == null) continue;
                        builder.add(productionComponentMonitor);
                    }
                    catch (RuntimeException runtimeException) {
                        Monitors.logCreateException(runtimeException, factory, object);
                    }
                }
                ImmutableCollection immutableCollection = builder.build();
                if (immutableCollection.isEmpty()) {
                    return ProductionComponentMonitor.noOp();
                }
                if (immutableCollection.size() == 1) {
                    return new NonThrowingProductionComponentMonitor((ProductionComponentMonitor)Iterables.getOnlyElement(immutableCollection));
                }
                return new DelegatingProductionComponentMonitor((ImmutableList<ProductionComponentMonitor>)immutableCollection);
            }
        }
    }

    private static final class NonThrowingProducerMonitor
    extends ProducerMonitor {
        private final ProducerMonitor delegate;

        NonThrowingProducerMonitor(ProducerMonitor producerMonitor) {
            this.delegate = producerMonitor;
        }

        @Override
        public void requested() {
            try {
                this.delegate.requested();
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorMethodException(runtimeException, this.delegate, "requested");
            }
        }

        @Override
        public void ready() {
            try {
                this.delegate.ready();
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorMethodException(runtimeException, this.delegate, "ready");
            }
        }

        @Override
        public void methodStarting() {
            try {
                this.delegate.methodStarting();
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorMethodException(runtimeException, this.delegate, "methodStarting");
            }
        }

        @Override
        public void methodFinished() {
            try {
                this.delegate.methodFinished();
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorMethodException(runtimeException, this.delegate, "methodFinished");
            }
        }

        @Override
        public void succeeded(Object object) {
            try {
                this.delegate.succeeded(object);
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorArgMethodException(runtimeException, this.delegate, "succeeded", object);
            }
        }

        @Override
        public void failed(Throwable throwable) {
            try {
                this.delegate.failed(throwable);
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorArgMethodException(runtimeException, this.delegate, "failed", throwable);
            }
        }
    }

    private static final class NonThrowingProductionComponentMonitor
    extends ProductionComponentMonitor {
        private final ProductionComponentMonitor delegate;

        NonThrowingProductionComponentMonitor(ProductionComponentMonitor productionComponentMonitor) {
            this.delegate = productionComponentMonitor;
        }

        @Override
        public ProducerMonitor producerMonitorFor(ProducerToken producerToken) {
            try {
                ProducerMonitor producerMonitor = this.delegate.producerMonitorFor(producerToken);
                return producerMonitor == null ? ProducerMonitor.noOp() : new NonThrowingProducerMonitor(producerMonitor);
            }
            catch (RuntimeException runtimeException) {
                Monitors.logProducerMonitorForException(runtimeException, this.delegate, producerToken);
                return ProducerMonitor.noOp();
            }
        }

        static final class Factory
        extends ProductionComponentMonitor.Factory {
            private final ProductionComponentMonitor.Factory delegate;

            Factory(ProductionComponentMonitor.Factory factory) {
                this.delegate = factory;
            }

            @Override
            public ProductionComponentMonitor create(Object object) {
                try {
                    ProductionComponentMonitor productionComponentMonitor = this.delegate.create(object);
                    return productionComponentMonitor == null ? ProductionComponentMonitor.noOp() : new NonThrowingProductionComponentMonitor(productionComponentMonitor);
                }
                catch (RuntimeException runtimeException) {
                    Monitors.logCreateException(runtimeException, this.delegate, object);
                    return ProductionComponentMonitor.noOp();
                }
            }
        }
    }
}

