/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentMonitor;
import dagger.producers.monitoring.ProductionComponentTimingRecorder;
import dagger.producers.monitoring.TimingProducerMonitor;

public final class TimingProductionComponentMonitor
extends ProductionComponentMonitor {
    private final ProductionComponentTimingRecorder recorder;
    private final Ticker ticker;
    private final Stopwatch stopwatch;

    TimingProductionComponentMonitor(ProductionComponentTimingRecorder productionComponentTimingRecorder, Ticker ticker) {
        this.recorder = productionComponentTimingRecorder;
        this.ticker = ticker;
        this.stopwatch = Stopwatch.createStarted(ticker);
    }

    @Override
    public ProducerMonitor producerMonitorFor(ProducerToken producerToken) {
        return new TimingProducerMonitor(this.recorder.producerTimingRecorderFor(producerToken), this.ticker, this.stopwatch);
    }

    public static final class Factory
    extends ProductionComponentMonitor.Factory {
        private final ProductionComponentTimingRecorder.Factory recorderFactory;
        private final Ticker ticker;

        public Factory(ProductionComponentTimingRecorder.Factory factory) {
            this(factory, Ticker.systemTicker());
        }

        Factory(ProductionComponentTimingRecorder.Factory factory, Ticker ticker) {
            this.recorderFactory = factory;
            this.ticker = ticker;
        }

        @Override
        public ProductionComponentMonitor create(Object object) {
            return new TimingProductionComponentMonitor(this.recorderFactory.create(object), this.ticker);
        }
    }
}

