/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.GwtIncompatible;
import dagger.internal.Preconditions;
import dagger.internal.ReferenceReleasingProvider;
import dagger.releasablereferences.ReleasableReferenceManager;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@GwtIncompatible
public final class ReferenceReleasingProviderManager
implements ReleasableReferenceManager {
    private final Class<? extends Annotation> scope;
    private final Queue<WeakReference<ReferenceReleasingProvider<?>>> providers = new ConcurrentLinkedQueue();

    public ReferenceReleasingProviderManager(Class<? extends Annotation> clazz) {
        this.scope = Preconditions.checkNotNull(clazz);
    }

    public void addProvider(ReferenceReleasingProvider<?> referenceReleasingProvider) {
        this.providers.add(new WeakReference(referenceReleasingProvider));
    }

    @Override
    public Class<? extends Annotation> scope() {
        return this.scope;
    }

    @Override
    public void releaseStrongReferences() {
        this.execute(Operation.RELEASE);
    }

    @Override
    public void restoreStrongReferences() {
        this.execute(Operation.RESTORE);
    }

    private void execute(Operation operation) {
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ReferenceReleasingProvider referenceReleasingProvider = (ReferenceReleasingProvider)((WeakReference)iterator.next()).get();
            if (referenceReleasingProvider == null) {
                iterator.remove();
                continue;
            }
            operation.execute(referenceReleasingProvider);
        }
    }

    private static enum Operation {
        RELEASE{

            @Override
            void execute(ReferenceReleasingProvider<?> referenceReleasingProvider) {
                referenceReleasingProvider.releaseStrongReference();
            }
        }
        ,
        RESTORE{

            @Override
            void execute(ReferenceReleasingProvider<?> referenceReleasingProvider) {
                referenceReleasingProvider.restoreStrongReference();
            }
        };


        abstract void execute(ReferenceReleasingProvider<?> var1);
    }
}

