/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMonthChooser
extends JPanel
implements ItemListener,
ChangeListener {
    protected boolean hasSpinner;
    private Locale locale;
    private int month;
    private int oldSpinnerValue = 0;
    private JDayChooser dayChooser;
    private JYearChooser yearChooser;
    private JComboBox comboBox;
    private JSpinner spinner;
    private boolean initialized;
    private boolean localInitialize;

    public JMonthChooser() {
        this(true);
    }

    public JMonthChooser(boolean bl) {
        this.hasSpinner = bl;
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.locale = Locale.getDefault();
        this.initNames();
        if (bl) {
            this.spinner = new JSpinner();
            this.spinner.addChangeListener(this);
            this.comboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.spinner.setEditor(this.comboBox);
            this.add((Component)this.spinner, "West");
        } else {
            this.add((Component)this.comboBox, "West");
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        for (int i = 0; i < 12; ++i) {
            this.comboBox.addItem(stringArray[i]);
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)((JSpinner)changeEvent.getSource()).getModel();
        int n = spinnerNumberModel.getNumber().intValue();
        boolean bl = n > this.oldSpinnerValue;
        this.oldSpinnerValue = n;
        int n2 = this.getMonth();
        if (bl) {
            if (++n2 == 12) {
                n2 = 0;
                if (this.yearChooser != null) {
                    int n3 = this.yearChooser.getYear();
                    this.yearChooser.setYear(++n3);
                }
            }
        } else if (--n2 == -1) {
            n2 = 11;
            if (this.yearChooser != null) {
                int n4 = this.yearChooser.getYear();
                this.yearChooser.setYear(--n4);
            }
        }
        this.setMonth(n2);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getStateChange() == 1 && (n = this.comboBox.getSelectedIndex()) >= 0 && n != this.month) {
            this.setMonth(n, false);
        }
    }

    private void setMonth(int n, boolean bl) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int n2 = this.month;
        this.month = n;
        if (bl) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n2, this.month);
    }

    public void setMonth(int n) {
        if (n < 0 || n > 11) {
            return;
        }
        this.setMonth(n, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jDayChooser) {
        this.dayChooser = jDayChooser;
    }

    public void setYearChooser(JYearChooser jYearChooser) {
        this.yearChooser = jYearChooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.initNames();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.comboBox.setEnabled(bl);
        if (this.spinner != null) {
            this.spinner.setEnabled(bl);
        }
    }

    public Component getComboBox() {
        return this.comboBox;
    }

    public Component getSpinner() {
        return this.spinner;
    }

    public boolean hasSpinner() {
        return this.hasSpinner;
    }

    @Override
    public String getName() {
        return "JMonthChooser";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("MonthChooser");
        jFrame.getContentPane().add(new JMonthChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

