/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.findersync.FSNativityControlImpl;
import com.liferay.nativity.control.unix.AppleNativityControlImpl;
import com.liferay.nativity.control.unix.LinuxNativityControlImpl;
import com.liferay.nativity.control.win.WindowsNativityControlImpl;
import com.liferay.nativity.util.OSDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativityControlUtil {
    private static Logger _logger = LoggerFactory.getLogger(NativityControlUtil.class.getName());
    private static NativityControl _nativityControl;

    public static NativityControl getNativityControl() {
        if (_nativityControl == null) {
            if (OSDetector.isApple()) {
                if (OSDetector.isMinimumAppleVersion("10.10")) {
                    return new FSNativityControlImpl();
                }
                _nativityControl = new AppleNativityControlImpl();
            } else if (OSDetector.isWindows()) {
                _nativityControl = new WindowsNativityControlImpl();
            } else if (OSDetector.isLinux()) {
                _nativityControl = new LinuxNativityControlImpl();
            } else {
                _logger.error("{} is not supported", (Object)System.getProperty("os.name"));
                _nativityControl = null;
            }
        }
        return _nativityControl;
    }
}

