/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.view;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.ValidationUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationComponentUtils {
    private static final Color MANDATORY_FOREGROUND = new Color(70, 70, 210);
    private static final Color MANDATORY_BACKGROUND = new Color(235, 235, 255);
    private static final Color ERROR_BACKGROUND = new Color(255, 215, 215);
    private static final Color WARNING_BACKGROUND = new Color(255, 235, 205);
    private static final String MANDATORY_KEY = "validation.isMandatory";
    private static final String MESSAGE_KEYS = "validation.messageKeys";
    private static final String INPUT_HINT_KEY = "validation.inputHint";
    private static final String SEVERITY_KEY = "validation.severity";
    private static final String STORED_BACKGROUND_KEY = "validation.storedBackground";
    private static Border mandatoryBorder;
    private static final Map<Class<? extends JTextComponent>, JTextComponent> PROTOTYPE_COMPONENTS;
    private static boolean lafChangeHandlerRegistered;

    private ValidationComponentUtils() {
    }

    public static boolean isMandatory(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty(MANDATORY_KEY));
    }

    public static boolean isMandatoryAndBlank(JComponent jComponent) {
        if (!(jComponent instanceof JTextComponent)) {
            return false;
        }
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        return ValidationComponentUtils.isMandatory(jTextComponent) && ValidationUtils.isBlank(jTextComponent.getText());
    }

    public static void setMandatory(JComponent jComponent, boolean bl) {
        boolean bl2 = ValidationComponentUtils.isMandatory(jComponent);
        if (bl2 != bl) {
            jComponent.putClientProperty(MANDATORY_KEY, bl);
        }
    }

    public static Severity getSeverity(JComponent jComponent) {
        return (Severity)((Object)jComponent.getClientProperty(SEVERITY_KEY));
    }

    public static void setSeverity(JComponent jComponent, Severity severity) {
        jComponent.putClientProperty(SEVERITY_KEY, (Object)severity);
    }

    public static Object[] getMessageKeys(JComponent jComponent) {
        return (Object[])jComponent.getClientProperty(MESSAGE_KEYS);
    }

    public static void setMessageKey(JComponent jComponent, Object object) {
        Object[] objectArray;
        if (object == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        Object[] objectArray3 = objectArray;
        ValidationComponentUtils.setMessageKeys(jComponent, objectArray3);
    }

    public static void setMessageKeys(JComponent jComponent, Object ... objectArray) {
        jComponent.putClientProperty(MESSAGE_KEYS, objectArray);
    }

    public static Object getInputHint(JComponent jComponent) {
        return jComponent.getClientProperty(INPUT_HINT_KEY);
    }

    public static void setInputHint(JComponent jComponent, Object object) {
        jComponent.putClientProperty(INPUT_HINT_KEY, object);
    }

    public static boolean hasError(JComponent jComponent, ValidationResult validationResult) {
        return validationResult.subResult(ValidationComponentUtils.getMessageKeys(jComponent)).hasErrors();
    }

    public static boolean hasWarning(JComponent jComponent, ValidationResult validationResult) {
        return validationResult.subResult(ValidationComponentUtils.getMessageKeys(jComponent)).hasWarnings();
    }

    public static Color getMandatoryBackground() {
        return MANDATORY_BACKGROUND;
    }

    public static Color getMandatoryForeground() {
        return MANDATORY_FOREGROUND;
    }

    public static void setMandatoryBackground(JTextComponent jTextComponent) {
        jTextComponent.setBackground(MANDATORY_BACKGROUND);
    }

    public static Color getErrorBackground() {
        return ERROR_BACKGROUND;
    }

    public static void setErrorBackground(JTextComponent jTextComponent) {
        jTextComponent.setBackground(ERROR_BACKGROUND);
    }

    public static Color getWarningBackground() {
        return WARNING_BACKGROUND;
    }

    public static void setWarningBackground(JTextComponent jTextComponent) {
        jTextComponent.setBackground(WARNING_BACKGROUND);
    }

    public static void setMandatoryBorder(JTextComponent jTextComponent) {
        Container container;
        Container container2 = jTextComponent.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            ((JScrollPane)container).setBorder(ValidationComponentUtils.getMandatoryBorder());
            return;
        }
        jTextComponent.setBorder(ValidationComponentUtils.getMandatoryBorder());
    }

    public static Border getMandatoryBorder() {
        if (mandatoryBorder == null) {
            mandatoryBorder = new CompoundBorder(new LineBorder(ValidationComponentUtils.getMandatoryForeground()), new BasicBorders.MarginBorder());
        }
        return mandatoryBorder;
    }

    public static void updateComponentTreeMandatoryBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryAndBlankBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryAndBlankBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryBorder(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBorderVisitor());
    }

    public static void updateComponentTreeSeverityBackground(Container container, ValidationResult validationResult) {
        ValidationComponentUtils.visitComponentTree(container, validationResult.keyMap(), new SeverityBackgroundVisitor());
    }

    public static void updateComponentTreeSeverity(Container container, ValidationResult validationResult) {
        ValidationComponentUtils.visitComponentTree(container, validationResult.keyMap(), new SeverityVisitor());
    }

    public static void visitComponentTree(Container container, Map<Object, ValidationResult> map, Visitor visitor) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTextComponent) {
                JComponent jComponent = (JComponent)component;
                visitor.visit(jComponent, map);
                continue;
            }
            if (!(component instanceof Container)) continue;
            ValidationComponentUtils.visitComponentTree((Container)component, map, visitor);
        }
    }

    public static ValidationResult getAssociatedResult(JComponent jComponent, Map<Object, ValidationResult> map) {
        Object[] objectArray = ValidationComponentUtils.getMessageKeys(jComponent);
        if (objectArray == null || map == null) {
            return null;
        }
        if (objectArray.length == 1) {
            ValidationResult validationResult = map.get(objectArray[0]);
            return validationResult == null ? ValidationResult.EMPTY : validationResult;
        }
        ValidationResult validationResult = null;
        for (Object object : objectArray) {
            ValidationResult validationResult2 = map.get(object);
            if (validationResult2 == null) continue;
            if (validationResult == null) {
                validationResult = new ValidationResult();
            }
            validationResult.addAllFrom(validationResult2);
        }
        return validationResult == null ? ValidationResult.EMPTY : ValidationResult.unmodifiableResult(validationResult);
    }

    private static Color getDefaultBackground(JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = ValidationComponentUtils.getPrototypeFor(jTextComponent.getClass());
        jTextComponent2.setEnabled(jTextComponent.isEnabled());
        jTextComponent2.setEditable(jTextComponent.isEditable());
        return jTextComponent2.getBackground();
    }

    private static JTextComponent getPrototypeFor(Class<? extends JTextComponent> clazz) {
        ValidationComponentUtils.ensureLookAndFeelChangeHandlerRegistered();
        JTextComponent jTextComponent = PROTOTYPE_COMPONENTS.get(clazz);
        if (jTextComponent == null) {
            try {
                jTextComponent = clazz.newInstance();
            }
            catch (Exception exception) {
                jTextComponent = new JTextField();
            }
            PROTOTYPE_COMPONENTS.put(clazz, jTextComponent);
        }
        return jTextComponent;
    }

    private static Color getStoredBackground(JTextComponent jTextComponent) {
        return (Color)jTextComponent.getClientProperty(STORED_BACKGROUND_KEY);
    }

    private static void ensureCustomBackgroundStored(JTextComponent jTextComponent) {
        if (ValidationComponentUtils.getStoredBackground(jTextComponent) != null) {
            return;
        }
        Color color = jTextComponent.getBackground();
        if (color == null || color instanceof UIResource || color == WARNING_BACKGROUND || color == ERROR_BACKGROUND) {
            return;
        }
        jTextComponent.putClientProperty(STORED_BACKGROUND_KEY, color);
    }

    private static void restoreBackground(JTextComponent jTextComponent) {
        Color color = ValidationComponentUtils.getStoredBackground(jTextComponent);
        jTextComponent.setBackground(color == null ? ValidationComponentUtils.getDefaultBackground(jTextComponent) : color);
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!lafChangeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
            lafChangeHandlerRegistered = true;
        }
    }

    static {
        PROTOTYPE_COMPONENTS = new HashMap<Class<? extends JTextComponent>, JTextComponent>();
        lafChangeHandlerRegistered = false;
    }

    private static final class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("lookAndFeel")) {
                PROTOTYPE_COMPONENTS.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SeverityVisitor
    implements Visitor {
        private SeverityVisitor() {
        }

        @Override
        public void visit(JComponent jComponent, Map<Object, ValidationResult> map) {
            ValidationResult validationResult = ValidationComponentUtils.getAssociatedResult(jComponent, map);
            Severity severity = validationResult == null ? null : validationResult.getSeverity();
            ValidationComponentUtils.setSeverity(jComponent, severity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SeverityBackgroundVisitor
    implements Visitor {
        private SeverityBackgroundVisitor() {
        }

        @Override
        public void visit(JComponent jComponent, Map<Object, ValidationResult> map) {
            Object[] objectArray = ValidationComponentUtils.getMessageKeys(jComponent);
            if (objectArray == null) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            ValidationComponentUtils.ensureCustomBackgroundStored(jTextComponent);
            ValidationResult validationResult = ValidationComponentUtils.getAssociatedResult(jComponent, map);
            if (validationResult == null || validationResult.isEmpty()) {
                ValidationComponentUtils.restoreBackground(jTextComponent);
            } else if (validationResult.hasErrors()) {
                ValidationComponentUtils.setErrorBackground(jTextComponent);
            } else if (validationResult.hasWarnings()) {
                ValidationComponentUtils.setWarningBackground(jTextComponent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MandatoryBorderVisitor
    implements Visitor {
        private MandatoryBorderVisitor() {
        }

        @Override
        public void visit(JComponent jComponent, Map<Object, ValidationResult> map) {
            if (jComponent instanceof JTextComponent && ValidationComponentUtils.isMandatory(jComponent)) {
                ValidationComponentUtils.setMandatoryBorder((JTextComponent)jComponent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MandatoryAndBlankBackgroundVisitor
    implements Visitor {
        private MandatoryAndBlankBackgroundVisitor() {
        }

        @Override
        public void visit(JComponent jComponent, Map<Object, ValidationResult> map) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (ValidationComponentUtils.isMandatoryAndBlank(jTextComponent)) {
                ValidationComponentUtils.setMandatoryBackground(jTextComponent);
            } else {
                ValidationComponentUtils.restoreBackground(jTextComponent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MandatoryBackgroundVisitor
    implements Visitor {
        private MandatoryBackgroundVisitor() {
        }

        @Override
        public void visit(JComponent jComponent, Map<Object, ValidationResult> map) {
            if (jComponent instanceof JTextComponent && ValidationComponentUtils.isMandatory(jComponent)) {
                ValidationComponentUtils.setMandatoryBackground((JTextComponent)jComponent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor {
        public void visit(JComponent var1, Map<Object, ValidationResult> var2);
    }
}

