/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.message;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.message.AbstractValidationMessage;
import com.jgoodies.validation.util.ValidationUtils;

public final class PropertyValidationMessage
extends AbstractValidationMessage {
    private final Object target;
    private final String role;
    private final String property;

    public PropertyValidationMessage(String string, Object object, String string2, String string3) {
        this(Severity.WARNING, string, object, string2, string3);
    }

    public PropertyValidationMessage(Severity severity, String string, Object object, String string2, String string3) {
        super(string, severity);
        if (object == null) {
            throw new NullPointerException("The target must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("The role must not be null.");
        }
        if (string3 == null) {
            throw new NullPointerException("The property must not be null.");
        }
        this.target = object;
        this.role = string2;
        this.property = string3;
    }

    public Object target() {
        return this.target;
    }

    public String role() {
        return this.role;
    }

    public String property() {
        return this.property;
    }

    public String aspect() {
        return this.role() + "." + this.property();
    }

    public String formattedText() {
        return this.aspect() + " " + this.text();
    }

    public Object key() {
        return this.aspect();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyValidationMessage)) {
            return false;
        }
        PropertyValidationMessage propertyValidationMessage = (PropertyValidationMessage)object;
        return this.severity().equals((Object)propertyValidationMessage.severity()) && ValidationUtils.equals(this.text(), propertyValidationMessage.text()) && ValidationUtils.equals(this.target(), propertyValidationMessage.target()) && ValidationUtils.equals(this.role(), propertyValidationMessage.role()) && ValidationUtils.equals(this.property(), propertyValidationMessage.property());
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.severity().hashCode();
        n = 37 * n + (this.text() == null ? 0 : this.text().hashCode());
        n = 37 * n + (this.target() == null ? 0 : this.target().hashCode());
        n = 37 * n + (this.role() == null ? 0 : this.role().hashCode());
        n = 37 * n + (this.property() == null ? 0 : this.property().hashCode());
        return n;
    }
}

