/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;

public final class FormUtils {
    private static Boolean cachedIsLafAqua;
    private static boolean lafChangeHandlerRegistered;

    private FormUtils() {
    }

    public static void assertNotBlank(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("The " + string2 + " must not be null.");
        }
        if (FormUtils.isBlank(string)) {
            throw new IllegalArgumentException("The " + string2 + " must not be empty, or whitespace. " + "See FormUtils.isBlank(String)");
        }
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The " + string + " must not be null.");
        }
    }

    public static boolean equals(Object object, Object object2) {
        return object != null && object2 != null && object.equals(object2) || object == null && object2 == null;
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = FormUtils.computeIsLafAqua();
            FormUtils.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!lafChangeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
            lafChangeHandlerRegistered = true;
        }
    }

    private static boolean computeIsLafAqua() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    static {
        lafChangeHandlerRegistered = false;
    }

    private static final class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("lookAndFeel")) {
                cachedIsLafAqua = null;
            }
        }
    }
}

