/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class TextComponentConnector {
    private final ValueModel subject;
    private final JTextComponent textComponent;
    private Document document;
    private final SubjectValueChangeHandler subjectValueChangeHandler;
    private final DocumentListener textChangeHandler;
    private final PropertyChangeListener documentChangeHandler;

    public TextComponentConnector(ValueModel valueModel, JTextArea jTextArea) {
        this(valueModel, (JTextComponent)jTextArea);
    }

    public TextComponentConnector(ValueModel valueModel, JTextField jTextField) {
        this(valueModel, (JTextComponent)jTextField);
    }

    private TextComponentConnector(ValueModel valueModel, JTextComponent jTextComponent) {
        if (valueModel == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        if (jTextComponent == null) {
            throw new NullPointerException("The text component must not be null.");
        }
        this.subject = valueModel;
        this.textComponent = jTextComponent;
        this.subjectValueChangeHandler = new SubjectValueChangeHandler();
        this.textChangeHandler = new TextChangeHandler();
        this.document = jTextComponent.getDocument();
        this.reregisterTextChangeHandler(null, this.document);
        valueModel.addValueChangeListener(this.subjectValueChangeHandler);
        this.documentChangeHandler = new DocumentChangeHandler();
        jTextComponent.addPropertyChangeListener("document", this.documentChangeHandler);
    }

    public static void connect(ValueModel valueModel, JTextArea jTextArea) {
        new TextComponentConnector(valueModel, jTextArea);
    }

    public static void connect(ValueModel valueModel, JTextField jTextField) {
        new TextComponentConnector(valueModel, jTextField);
    }

    public void updateSubject() {
        this.setSubjectText(this.getDocumentText());
    }

    public void updateTextComponent() {
        this.setDocumentTextSilently(this.getSubjectText());
    }

    private String getDocumentText() {
        return this.textComponent.getText();
    }

    private void setDocumentTextSilently(String string) {
        this.textComponent.getDocument().removeDocumentListener(this.textChangeHandler);
        this.textComponent.setText(string);
        this.textComponent.setCaretPosition(0);
        this.textComponent.getDocument().addDocumentListener(this.textChangeHandler);
    }

    private String getSubjectText() {
        String string = (String)this.subject.getValue();
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubjectText(String string) {
        this.subjectValueChangeHandler.setUpdateLater(true);
        try {
            this.subject.setValue(string);
        }
        finally {
            this.subjectValueChangeHandler.setUpdateLater(false);
        }
    }

    private void reregisterTextChangeHandler(Document document, Document document2) {
        if (document != null) {
            document.removeDocumentListener(this.textChangeHandler);
        }
        if (document2 != null) {
            document2.addDocumentListener(this.textChangeHandler);
        }
    }

    public void release() {
        this.reregisterTextChangeHandler(this.document, null);
        this.subject.removeValueChangeListener(this.subjectValueChangeHandler);
        this.textComponent.removePropertyChangeListener("document", this.documentChangeHandler);
    }

    private final class DocumentChangeHandler
    implements PropertyChangeListener {
        private DocumentChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Document document = TextComponentConnector.this.document;
            Document document2 = TextComponentConnector.this.textComponent.getDocument();
            TextComponentConnector.this.reregisterTextChangeHandler(document, document2);
            TextComponentConnector.this.document = document2;
        }
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private boolean updateLater;

        private SubjectValueChangeHandler() {
        }

        void setUpdateLater(boolean bl) {
            this.updateLater = bl;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            String string2 = TextComponentConnector.this.getDocumentText();
            Object object = propertyChangeEvent.getNewValue();
            String string3 = string = object == null ? TextComponentConnector.this.getSubjectText() : (String)object;
            if (BindingUtils.equals(string2, string)) {
                return;
            }
            if (this.updateLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TextComponentConnector.this.setDocumentTextSilently(string);
                    }
                });
            } else {
                TextComponentConnector.this.setDocumentTextSilently(string);
            }
        }
    }

    private final class TextChangeHandler
    implements DocumentListener {
        private TextChangeHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextComponentConnector.this.updateSubject();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextComponentConnector.this.updateSubject();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

