/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.ColorSelectionAdapter;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.adapter.TextComponentConnector;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ComponentValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bindings {
    private static final String COMMIT_ON_FOCUS_LOST_MODEL_KEY = "commitOnFocusListModel";
    private static final String COMPONENT_VALUE_MODEL_KEY = "componentValueModel";
    private static final String COMPONENT_PROPERTY_HANDLER_KEY = "componentPropertyHandler";
    static final FocusLostHandler FOCUS_LOST_HANDLER = new FocusLostHandler();
    static final WeakTrigger FOCUS_LOST_TRIGGER = new WeakTrigger();

    private Bindings() {
    }

    public static void bind(JCheckBox jCheckBox, ValueModel valueModel) {
        boolean bl = jCheckBox.getModel().isEnabled();
        jCheckBox.setModel(new ToggleButtonAdapter(valueModel));
        jCheckBox.setEnabled(bl);
        Bindings.addComponentPropertyHandler(jCheckBox, valueModel);
    }

    public static void bind(JCheckBoxMenuItem jCheckBoxMenuItem, ValueModel valueModel) {
        boolean bl = jCheckBoxMenuItem.getModel().isEnabled();
        jCheckBoxMenuItem.setModel(new ToggleButtonAdapter(valueModel));
        jCheckBoxMenuItem.setEnabled(bl);
        Bindings.addComponentPropertyHandler(jCheckBoxMenuItem, valueModel);
    }

    public static void bind(JColorChooser jColorChooser, ValueModel valueModel) {
        jColorChooser.setSelectionModel(new ColorSelectionAdapter(valueModel));
    }

    public static void bind(JColorChooser jColorChooser, ValueModel valueModel, Color color) {
        if (color == null) {
            throw new NullPointerException("The default color must not be null.");
        }
        jColorChooser.setSelectionModel(new ColorSelectionAdapter(valueModel, color));
    }

    public static <E> void bind(JComboBox jComboBox, SelectionInList<E> selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        jComboBox.setModel(new ComboBoxAdapter<E>(selectionInList));
        Bindings.addComponentPropertyHandler(jComboBox, selectionInList.getSelectionHolder());
    }

    public static void bind(JFormattedTextField jFormattedTextField, ValueModel valueModel) {
        Bindings.bind((JComponent)jFormattedTextField, "value", valueModel);
    }

    public static void bind(JLabel jLabel, ValueModel valueModel) {
        Bindings.bind(jLabel, "text", valueModel);
    }

    public static <E> void bind(JList jList, SelectionInList<E> selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        jList.setModel(selectionInList);
        jList.setSelectionModel(new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder()));
        Bindings.addComponentPropertyHandler(jList, selectionInList.getSelectionHolder());
    }

    public static void bind(JRadioButton jRadioButton, ValueModel valueModel, Object object) {
        boolean bl = jRadioButton.getModel().isEnabled();
        jRadioButton.setModel(new RadioButtonAdapter(valueModel, object));
        jRadioButton.setEnabled(bl);
        Bindings.addComponentPropertyHandler(jRadioButton, valueModel);
    }

    public static void bind(JRadioButtonMenuItem jRadioButtonMenuItem, ValueModel valueModel, Object object) {
        boolean bl = jRadioButtonMenuItem.getModel().isEnabled();
        jRadioButtonMenuItem.setModel(new RadioButtonAdapter(valueModel, object));
        jRadioButtonMenuItem.setEnabled(bl);
        Bindings.addComponentPropertyHandler(jRadioButtonMenuItem, valueModel);
    }

    public static void bind(JTextArea jTextArea, ValueModel valueModel) {
        Bindings.bind(jTextArea, valueModel, false);
    }

    public static void bind(JTextArea jTextArea, ValueModel valueModel, boolean bl) {
        ValueModel valueModel2;
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        if (bl) {
            valueModel2 = Bindings.createCommitOnFocusLostModel(valueModel, jTextArea);
            jTextArea.putClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY, valueModel2);
        } else {
            valueModel2 = valueModel;
        }
        TextComponentConnector textComponentConnector = new TextComponentConnector(valueModel2, jTextArea);
        textComponentConnector.updateTextComponent();
        Bindings.addComponentPropertyHandler(jTextArea, valueModel);
    }

    public static void bind(JTextField jTextField, ValueModel valueModel) {
        Bindings.bind(jTextField, valueModel, false);
    }

    public static void bind(JTextField jTextField, ValueModel valueModel, boolean bl) {
        ValueModel valueModel2;
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        if (bl) {
            valueModel2 = Bindings.createCommitOnFocusLostModel(valueModel, jTextField);
            jTextField.putClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY, valueModel2);
        } else {
            valueModel2 = valueModel;
        }
        TextComponentConnector textComponentConnector = new TextComponentConnector(valueModel2, jTextField);
        textComponentConnector.updateTextComponent();
        Bindings.addComponentPropertyHandler(jTextField, valueModel);
    }

    public static void bind(JComponent jComponent, String string, ValueModel valueModel) {
        if (jComponent == null) {
            throw new NullPointerException("The component must not be null.");
        }
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        PropertyConnector.connectAndUpdate(valueModel, jComponent, string);
        Bindings.addComponentPropertyHandler(jComponent, valueModel);
    }

    public static void addComponentPropertyHandler(JComponent jComponent, ValueModel valueModel) {
        if (!(valueModel instanceof ComponentValueModel)) {
            return;
        }
        ComponentValueModel componentValueModel = (ComponentValueModel)valueModel;
        ComponentPropertyHandler componentPropertyHandler = new ComponentPropertyHandler(jComponent);
        componentValueModel.addPropertyChangeListener(componentPropertyHandler);
        jComponent.putClientProperty(COMPONENT_VALUE_MODEL_KEY, componentValueModel);
        jComponent.putClientProperty(COMPONENT_PROPERTY_HANDLER_KEY, componentPropertyHandler);
        jComponent.setEnabled(componentValueModel.isEnabled());
        jComponent.setVisible(componentValueModel.isVisible());
        if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setEditable(componentValueModel.isEditable());
        }
    }

    public static void removeComponentPropertyHandler(JComponent jComponent) {
        ComponentValueModel componentValueModel = (ComponentValueModel)jComponent.getClientProperty(COMPONENT_VALUE_MODEL_KEY);
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jComponent.getClientProperty(COMPONENT_PROPERTY_HANDLER_KEY);
        if (componentValueModel == null || propertyChangeListener == null) {
            if (componentValueModel == null && propertyChangeListener == null) {
                return;
            }
            if (componentValueModel != null) {
                throw new IllegalStateException("The component has a ComponentValueModel stored, but lacks the ComponentPropertyHandler.");
            }
            throw new IllegalStateException("The component has a ComponentPropertyHandler stored, but lacks the ComponentValueModel.");
        }
        componentValueModel.removePropertyChangeListener(propertyChangeListener);
        jComponent.putClientProperty(COMPONENT_VALUE_MODEL_KEY, null);
        jComponent.putClientProperty(COMPONENT_PROPERTY_HANDLER_KEY, null);
    }

    public static void commitImmediately() {
        FOCUS_LOST_TRIGGER.triggerCommit();
    }

    public static boolean flushImmediately() {
        boolean bl = Bindings.isFocusOwnerBuffering();
        if (bl) {
            FOCUS_LOST_TRIGGER.triggerFlush();
        }
        return bl;
    }

    public static boolean isFocusOwnerBuffering() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(component instanceof JComponent)) {
            return false;
        }
        Object object = ((JComponent)component).getClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY);
        if (!(object instanceof BufferedValueModel)) {
            return false;
        }
        BufferedValueModel bufferedValueModel = (BufferedValueModel)object;
        return bufferedValueModel.isBuffering();
    }

    private static ValueModel createCommitOnFocusLostModel(ValueModel valueModel, Component component) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        BufferedValueModel bufferedValueModel = new BufferedValueModel(valueModel, FOCUS_LOST_TRIGGER);
        component.addFocusListener(FOCUS_LOST_HANDLER);
        return bufferedValueModel;
    }

    private static final class WeakPropertyChangeSupport
    extends PropertyChangeSupport {
        static final ReferenceQueue<PropertyChangeListener> QUEUE = new ReferenceQueue();

        WeakPropertyChangeSupport(Object object) {
            super(object);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
                this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
            } else {
                super.addPropertyChangeListener(new WeakPropertyChangeListener(propertyChangeListener));
            }
        }

        public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            super.addPropertyChangeListener(string, new WeakPropertyChangeListener(string, propertyChangeListener));
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
                this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
                return;
            }
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener weakPropertyChangeListener;
                if (propertyChangeListenerArray[i] instanceof PropertyChangeListenerProxy || (weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListenerArray[i]).get() != propertyChangeListener) continue;
                super.removePropertyChangeListener(weakPropertyChangeListener);
                break;
            }
        }

        public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners(string);
            for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListenerArray[i];
                if (weakPropertyChangeListener.get() != propertyChangeListener) continue;
                super.removePropertyChangeListener(string, weakPropertyChangeListener);
                break;
            }
        }

        public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(propertyChangeEvent);
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(string, object, object2);
        }

        private static void cleanUp() {
            WeakPropertyChangeListener weakPropertyChangeListener;
            while ((weakPropertyChangeListener = (WeakPropertyChangeListener)QUEUE.poll()) != null) {
                weakPropertyChangeListener.removeListener();
            }
        }

        void removeWeakPropertyChangeListener(WeakPropertyChangeListener weakPropertyChangeListener) {
            if (weakPropertyChangeListener.propertyName == null) {
                super.removePropertyChangeListener(weakPropertyChangeListener);
            } else {
                super.removePropertyChangeListener(weakPropertyChangeListener.propertyName, weakPropertyChangeListener);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class WeakPropertyChangeListener
        extends WeakReference<PropertyChangeListener>
        implements PropertyChangeListener {
            final String propertyName;

            private WeakPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this(null, propertyChangeListener);
            }

            private WeakPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
                super(propertyChangeListener, QUEUE);
                this.propertyName = string;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
                if (propertyChangeListener != null) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }

            void removeListener() {
                WeakPropertyChangeSupport.this.removeWeakPropertyChangeListener(this);
            }
        }
    }

    private static final class WeakTrigger
    implements ValueModel {
        private final transient WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport(this);
        private Boolean value = null;

        WeakTrigger() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            if (object != null && !(object instanceof Boolean)) {
                throw new IllegalArgumentException("Trigger values must be of type Boolean.");
            }
            Boolean bl = this.value;
            this.value = (Boolean)object;
            this.fireValueChange(bl, object);
        }

        public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            this.changeSupport.addPropertyChangeListener("value", propertyChangeListener);
        }

        public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener("value", propertyChangeListener);
        }

        private void fireValueChange(Object object, Object object2) {
            this.changeSupport.firePropertyChange("value", object, object2);
        }

        void triggerCommit() {
            if (Boolean.TRUE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.TRUE);
        }

        void triggerFlush() {
            if (Boolean.FALSE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.FALSE);
        }
    }

    private static final class ComponentPropertyHandler
    implements PropertyChangeListener {
        private final JComponent component;

        private ComponentPropertyHandler(JComponent jComponent) {
            this.component = jComponent;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ComponentValueModel componentValueModel = (ComponentValueModel)propertyChangeEvent.getSource();
            if ("enabled".equals(string)) {
                this.component.setEnabled(componentValueModel.isEnabled());
            } else if ("visible".equals(string)) {
                this.component.setVisible(componentValueModel.isVisible());
            } else if ("editable".equals(string) && this.component instanceof JTextComponent) {
                ((JTextComponent)this.component).setEditable(componentValueModel.isEditable());
            }
        }
    }

    private static final class FocusLostHandler
    extends FocusAdapter {
        private FocusLostHandler() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FOCUS_LOST_TRIGGER.triggerCommit();
            }
        }
    }
}

