/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

abstract class AbstractHashFunction
implements HashFunction {
    AbstractHashFunction() {
    }

    @Override
    public <T> HashCode hashObject(T t, Funnel<? super T> funnel) {
        return this.newHasher().putObject(t, funnel).hash();
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n = charSequence.length();
        return this.newHasher(n * 2).putUnencodedChars(charSequence).hash();
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        return this.newHasher().putString(charSequence, charset).hash();
    }

    @Override
    public HashCode hashInt(int n) {
        return this.newHasher(4).putInt(n).hash();
    }

    @Override
    public HashCode hashLong(long l) {
        return this.newHasher(8).putLong(l).hash();
    }

    @Override
    public HashCode hashBytes(byte[] byArray) {
        return this.hashBytes(byArray, 0, byArray.length);
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n, int n2) {
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        return this.newHasher(n2).putBytes(byArray, n, n2).hash();
    }

    @Override
    public HashCode hashBytes(ByteBuffer byteBuffer) {
        return this.newHasher(byteBuffer.remaining()).putBytes(byteBuffer).hash();
    }

    @Override
    public Hasher newHasher(int n) {
        Preconditions.checkArgument(n >= 0, "expectedInputSize must be >= 0 but was %s", n);
        return this.newHasher();
    }
}

