/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.NumberInput;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class StdDateFormat
extends DateFormat {
    public static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String DATE_FORMAT_STR_ISO8601_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String DATE_FORMAT_STR_PLAIN = "yyyy-MM-dd";
    protected static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String[] ALL_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd"};
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final Locale DEFAULT_LOCALE = Locale.US;
    protected static final DateFormat DATE_FORMAT_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", DEFAULT_LOCALE);
    protected static final DateFormat DATE_FORMAT_ISO8601;
    protected static final DateFormat DATE_FORMAT_ISO8601_Z;
    protected static final DateFormat DATE_FORMAT_PLAIN;
    public static final StdDateFormat instance;
    protected transient TimeZone _timezone;
    protected final Locale _locale;
    protected Boolean _lenient;
    protected transient DateFormat _formatRFC1123;
    protected transient DateFormat _formatISO8601;
    protected transient DateFormat _formatISO8601_z;
    protected transient DateFormat _formatPlain;

    public StdDateFormat() {
        this._locale = DEFAULT_LOCALE;
    }

    @Deprecated
    public StdDateFormat(TimeZone timeZone, Locale locale) {
        this._timezone = timeZone;
        this._locale = locale;
    }

    protected StdDateFormat(TimeZone timeZone, Locale locale, Boolean bl) {
        this._timezone = timeZone;
        this._locale = locale;
        this._lenient = bl;
    }

    public static TimeZone getDefaultTimeZone() {
        return DEFAULT_TIMEZONE;
    }

    public StdDateFormat withTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        if (timeZone == this._timezone || timeZone.equals(this._timezone)) {
            return this;
        }
        return new StdDateFormat(timeZone, this._locale, this._lenient);
    }

    public StdDateFormat withLocale(Locale locale) {
        if (locale.equals(this._locale)) {
            return this;
        }
        return new StdDateFormat(this._timezone, locale, this._lenient);
    }

    @Override
    public StdDateFormat clone() {
        return new StdDateFormat(this._timezone, this._locale, this._lenient);
    }

    @Deprecated
    public static DateFormat getISO8601Format(TimeZone timeZone) {
        return StdDateFormat.getISO8601Format(timeZone, DEFAULT_LOCALE);
    }

    public static DateFormat getISO8601Format(TimeZone timeZone, Locale locale) {
        return StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601, DATE_FORMAT_STR_ISO8601, timeZone, locale, null);
    }

    public static DateFormat getRFC1123Format(TimeZone timeZone, Locale locale) {
        return StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, timeZone, locale, null);
    }

    @Deprecated
    public static DateFormat getRFC1123Format(TimeZone timeZone) {
        return StdDateFormat.getRFC1123Format(timeZone, DEFAULT_LOCALE);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timezone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this._timezone)) {
            this._clearFormats();
            this._timezone = timeZone;
        }
    }

    @Override
    public void setLenient(boolean bl) {
        Boolean bl2 = bl;
        if (this._lenient != bl2) {
            this._lenient = bl2;
            this._clearFormats();
        }
    }

    @Override
    public boolean isLenient() {
        if (this._lenient == null) {
            return true;
        }
        return this._lenient;
    }

    @Override
    public Date parse(String string) throws ParseException {
        Date date;
        string = string.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        if (this.looksLikeISO8601(string)) {
            date = this.parseAsISO8601(string, parsePosition, true);
        } else {
            char c;
            int n = string.length();
            while (--n >= 0 && ((c = string.charAt(n)) >= '0' && c <= '9' || n <= 0 && c == '-')) {
            }
            date = n < 0 && (string.charAt(0) == '-' || NumberInput.inLongRange(string, false)) ? new Date(Long.parseLong(string)) : this.parseAsRFC1123(string, parsePosition);
        }
        if (date != null) {
            return date;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : ALL_FORMATS) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\", \"");
            } else {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append('\"');
        throw new ParseException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (%s)", string, stringBuilder.toString()), parsePosition.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        char c;
        if (this.looksLikeISO8601(string)) {
            try {
                return this.parseAsISO8601(string, parsePosition, false);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        int n = string.length();
        while (--n >= 0 && ((c = string.charAt(n)) >= '0' && c <= '9' || n <= 0 && c == '-')) {
        }
        if (n < 0 && (string.charAt(0) == '-' || NumberInput.inLongRange(string, false))) {
            return new Date(Long.parseLong(string));
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this._formatISO8601 == null) {
            this._formatISO8601 = StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601, DATE_FORMAT_STR_ISO8601, this._timezone, this._locale, this._lenient);
        }
        return this._formatISO8601.format(date, stringBuffer, fieldPosition);
    }

    public String toString() {
        String string = "DateFormat " + this.getClass().getName();
        TimeZone timeZone = this._timezone;
        if (timeZone != null) {
            string = string + " (timezone: " + timeZone + ")";
        }
        string = string + "(locale: " + this._locale + ")";
        return string;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected boolean looksLikeISO8601(String string) {
        return string.length() >= 5 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-';
    }

    protected Date parseAsISO8601(String string, ParsePosition parsePosition, boolean bl) throws ParseException {
        Comparable<StringBuilder> comparable;
        String string2;
        DateFormat dateFormat;
        int n = string.length();
        char c = string.charAt(n - 1);
        if (n <= 10 && Character.isDigit(c)) {
            dateFormat = this._formatPlain;
            string2 = DATE_FORMAT_STR_PLAIN;
            if (dateFormat == null) {
                dateFormat = this._formatPlain = StdDateFormat._cloneFormat(DATE_FORMAT_PLAIN, string2, this._timezone, this._locale, this._lenient);
            }
        } else if (c == 'Z') {
            dateFormat = this._formatISO8601_z;
            string2 = DATE_FORMAT_STR_ISO8601_Z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601_Z, string2, this._timezone, this._locale, this._lenient);
            }
            if (string.charAt(n - 4) == ':') {
                comparable = new StringBuilder(string);
                ((StringBuilder)comparable).insert(n - 1, ".000");
                string = ((StringBuilder)comparable).toString();
            }
        } else if (StdDateFormat.hasTimeZone(string)) {
            c = string.charAt(n - 3);
            if (c == ':') {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.delete(n - 3, n - 2);
                string = stringBuilder.toString();
            } else if (c == '+' || c == '-') {
                string = string + "00";
            }
            n = string.length();
            int n2 = n - string.lastIndexOf(84) - 6;
            if (n2 < 12) {
                int n3 = n - 5;
                StringBuilder stringBuilder = new StringBuilder(string);
                switch (n2) {
                    case 11: {
                        stringBuilder.insert(n3, '0');
                        break;
                    }
                    case 10: {
                        stringBuilder.insert(n3, "00");
                        break;
                    }
                    case 9: {
                        stringBuilder.insert(n3, "000");
                        break;
                    }
                    case 8: {
                        stringBuilder.insert(n3, ".000");
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 6: {
                        stringBuilder.insert(n3, "00.000");
                    }
                    case 5: {
                        stringBuilder.insert(n3, ":00.000");
                    }
                }
                string = stringBuilder.toString();
            }
            dateFormat = this._formatISO8601;
            string2 = DATE_FORMAT_STR_ISO8601;
            if (this._formatISO8601 == null) {
                dateFormat = this._formatISO8601 = StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601, string2, this._timezone, this._locale, this._lenient);
            }
        } else {
            comparable = new StringBuilder(string);
            int n4 = n - string.lastIndexOf(84) - 1;
            if (n4 < 12) {
                switch (n4) {
                    case 11: {
                        ((StringBuilder)comparable).append('0');
                    }
                    case 10: {
                        ((StringBuilder)comparable).append('0');
                    }
                    case 9: {
                        ((StringBuilder)comparable).append('0');
                        break;
                    }
                    default: {
                        ((StringBuilder)comparable).append(".000");
                    }
                }
            }
            ((StringBuilder)comparable).append('Z');
            string = ((StringBuilder)comparable).toString();
            dateFormat = this._formatISO8601_z;
            string2 = DATE_FORMAT_STR_ISO8601_Z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601_Z, string2, this._timezone, this._locale, this._lenient);
            }
        }
        if ((comparable = dateFormat.parse(string, parsePosition)) == null) {
            throw new ParseException(String.format("Can not parse date \"%s\": while it seems to fit format '%s', parsing fails (leniency? %s)", string, string2, this._lenient), parsePosition.getErrorIndex());
        }
        return comparable;
    }

    protected Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, this._timezone, this._locale, this._lenient);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    private static final boolean hasTimeZone(String string) {
        int n = string.length();
        if (n >= 6) {
            char c = string.charAt(n - 6);
            if (c == '+' || c == '-') {
                return true;
            }
            c = string.charAt(n - 5);
            if (c == '+' || c == '-') {
                return true;
            }
            c = string.charAt(n - 3);
            if (c == '+' || c == '-') {
                return true;
            }
        }
        return false;
    }

    private static final DateFormat _cloneFormat(DateFormat dateFormat, String string, TimeZone timeZone, Locale locale, Boolean bl) {
        if (!locale.equals(DEFAULT_LOCALE)) {
            dateFormat = new SimpleDateFormat(string, locale);
            dateFormat.setTimeZone(timeZone == null ? DEFAULT_TIMEZONE : timeZone);
        } else {
            dateFormat = (DateFormat)dateFormat.clone();
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
        }
        if (bl != null) {
            dateFormat.setLenient(bl);
        }
        return dateFormat;
    }

    protected void _clearFormats() {
        this._formatRFC1123 = null;
        this._formatISO8601 = null;
        this._formatISO8601_z = null;
        this._formatPlain = null;
    }

    static {
        DATE_FORMAT_RFC1123.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601, DEFAULT_LOCALE);
        DATE_FORMAT_ISO8601.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601_Z = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601_Z, DEFAULT_LOCALE);
        DATE_FORMAT_ISO8601_Z.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_PLAIN = new SimpleDateFormat(DATE_FORMAT_STR_PLAIN, DEFAULT_LOCALE);
        DATE_FORMAT_PLAIN.setTimeZone(DEFAULT_TIMEZONE);
        instance = new StdDateFormat();
    }
}

