/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.fasterxml.jackson.databind.ser.impl.IteratorSerializer;
import com.fasterxml.jackson.databind.ser.impl.MapEntrySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.ByteBufferSerializer;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSetSerializer;
import com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.InetSocketAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.IterableSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TimeZone;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete;
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy;
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        this._factoryConfig = serializerFactoryConfig == null ? new SerializerFactoryConfig() : serializerFactoryConfig;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(serializers));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(serializers));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(beanSerializerModifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig serializationConfig, JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        Object object;
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        JsonValueSerializer jsonValueSerializer = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers clazz2;
            object = this._factoryConfig.keySerializers().iterator();
            while (object.hasNext() && (jsonValueSerializer = (clazz2 = object.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
            }
        }
        if (jsonValueSerializer == null && (jsonValueSerializer = jsonSerializer) == null && (jsonValueSerializer = StdKeySerializers.getStdKeySerializer(serializationConfig, javaType.getRawClass(), false)) == null) {
            beanDescription = serializationConfig.introspect(javaType);
            object = beanDescription.findJsonValueMethod();
            if (object != null) {
                Class<?> clazz = ((AnnotatedMethod)object).getRawReturnType();
                JsonSerializer<Object> jsonSerializer2 = StdKeySerializers.getStdKeySerializer(serializationConfig, clazz, true);
                Method method = ((AnnotatedMethod)object).getAnnotated();
                if (serializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(method, serializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                jsonValueSerializer = new JsonValueSerializer((AnnotatedMethod)object, jsonSerializer2);
            } else {
                jsonValueSerializer = StdKeySerializers.getFallbackKeySerializer(serializationConfig, javaType.getRawClass());
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonValueSerializer = beanSerializerModifier.modifyKeySerializer(serializationConfig, javaType, beanDescription, jsonValueSerializer);
            }
        }
        return jsonValueSerializer;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(serializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = serializationConfig.getDefaultTyper(javaType);
        } else {
            collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedClass);
        }
        if (typeResolverBuilder == null) {
            return null;
        }
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType javaType, SerializationConfig serializationConfig, BeanDescription beanDescription, boolean bl) {
        Class<JsonSerializer<?>> clazz;
        Class<?> clazz2 = javaType.getRawClass();
        String string = clazz2.getName();
        JsonSerializer<?> jsonSerializer = _concrete.get(string);
        if (jsonSerializer == null && (clazz = _concreteLazy.get(string)) != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + clazz.getName() + "): " + exception.getMessage(), exception);
            }
        }
        return jsonSerializer;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(clazz)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod annotatedMethod = beanDescription.findJsonValueMethod();
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (serializerProvider.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method, serializerProvider.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMethod);
            return new JsonValueSerializer(annotatedMethod, jsonSerializer);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonSerializer<?> jsonSerializer = this.findOptionalStdSerializer(serializerProvider, javaType, beanDescription, bl);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DateSerializer.instance;
        }
        if (Map.Entry.class.isAssignableFrom(clazz)) {
            JavaType javaType2 = javaType.findSuperType(Map.Entry.class);
            JavaType javaType3 = javaType2.containedTypeOrUnknown(0);
            JavaType javaType4 = javaType2.containedTypeOrUnknown(1);
            return this.buildMapEntrySerializer(serializerProvider.getConfig(), javaType, beanDescription, bl, javaType3, javaType4);
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return new ByteBufferSerializer();
        }
        if (InetAddress.class.isAssignableFrom(clazz)) {
            return new InetAddressSerializer();
        }
        if (InetSocketAddress.class.isAssignableFrom(clazz)) {
            return new InetSocketAddressSerializer();
        }
        if (TimeZone.class.isAssignableFrom(clazz)) {
            return new TimeZoneSerializer();
        }
        if (Charset.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            JsonFormat.Value value = beanDescription.findExpectedFormat(null);
            if (value != null) {
                switch (value.getShape()) {
                    case STRING: {
                        return ToStringSerializer.instance;
                    }
                    case OBJECT: 
                    case ARRAY: {
                        return null;
                    }
                }
            }
            return NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.buildEnumSerializer(serializerProvider.getConfig(), javaType, beanDescription);
        }
        return null;
    }

    protected JsonSerializer<?> findOptionalStdSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findSerializer(serializerProvider.getConfig(), javaType, beanDescription);
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(clazz)) {
            JavaType[] javaTypeArray = serializationConfig.getTypeFactory().findTypeParameters(javaType, Iterator.class);
            JavaType javaType2 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            return this.buildIteratorSerializer(serializationConfig, javaType, beanDescription, bl, javaType2);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            JavaType[] javaTypeArray = serializationConfig.getTypeFactory().findTypeParameters(javaType, Iterable.class);
            JavaType javaType3 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            return this.buildIterableSerializer(serializationConfig, javaType, beanDescription, bl, javaType3);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializer(annotated);
        if (object == null) {
            return null;
        }
        JsonSerializer<Object> jsonSerializer = serializerProvider.serializerInstance(annotated, object);
        return this.findConvertingSerializer(serializerProvider, annotated, jsonSerializer);
    }

    protected JsonSerializer<?> findConvertingSerializer(SerializerProvider serializerProvider, Annotated annotated, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        Converter<Object, Object> converter = this.findConverter(serializerProvider, annotated);
        if (converter == null) {
            return jsonSerializer;
        }
        JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
        return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
    }

    protected Converter<Object, Object> findConverter(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return serializerProvider.converterInstance(annotated, object);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2;
        TypeSerializer typeSerializer;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (!(bl || !javaType.useStaticType() || javaType.isContainerType() && javaType.getContentType().getRawClass() == Object.class)) {
            bl = true;
        }
        if ((typeSerializer = this.createTypeSerializer(serializationConfig, javaType2 = javaType.getContentType())) != null) {
            bl = false;
        }
        JsonSerializer<Object> jsonSerializer = this._findContentSerializer(serializerProvider, beanDescription.getClassInfo());
        if (javaType.isMapLikeType()) {
            Serializers serializers;
            MapLikeType mapLikeType = (MapLikeType)javaType;
            JsonSerializer<Object> jsonSerializer2 = this._findKeySerializer(serializerProvider, beanDescription.getClassInfo());
            if (mapLikeType.isTrueMapType()) {
                return this.buildMapSerializer(serializerProvider, (MapType)mapLikeType, beanDescription, bl, jsonSerializer2, typeSerializer, jsonSerializer);
            }
            JsonSerializer<?> jsonSerializer3 = null;
            MapLikeType mapLikeType2 = (MapLikeType)javaType;
            Iterator<Serializers> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (jsonSerializer3 = (serializers = iterator.next()).findMapLikeSerializer(serializationConfig, mapLikeType2, beanDescription, jsonSerializer2, typeSerializer, jsonSerializer)) == null) {
            }
            if (jsonSerializer3 == null) {
                jsonSerializer3 = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
            if (jsonSerializer3 != null && this._factoryConfig.hasSerializerModifiers()) {
                for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                    jsonSerializer3 = beanSerializerModifier.modifyMapLikeSerializer(serializationConfig, mapLikeType2, beanDescription, jsonSerializer3);
                }
            }
            return jsonSerializer3;
        }
        if (javaType.isCollectionLikeType()) {
            Serializers serializers;
            CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
            if (collectionLikeType.isTrueCollectionType()) {
                return this.buildCollectionSerializer(serializerProvider, (CollectionType)collectionLikeType, beanDescription, bl, typeSerializer, jsonSerializer);
            }
            JsonSerializer<?> jsonSerializer4 = null;
            CollectionLikeType collectionLikeType2 = (CollectionLikeType)javaType;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (jsonSerializer4 = (serializers = iterator.next()).findCollectionLikeSerializer(serializationConfig, collectionLikeType2, beanDescription, typeSerializer, jsonSerializer)) == null) {
            }
            if (jsonSerializer4 == null) {
                jsonSerializer4 = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
            if (jsonSerializer4 != null && this._factoryConfig.hasSerializerModifiers()) {
                for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                    jsonSerializer4 = beanSerializerModifier.modifyCollectionLikeSerializer(serializationConfig, collectionLikeType2, beanDescription, jsonSerializer4);
                }
            }
            return jsonSerializer4;
        }
        if (javaType.isArrayType()) {
            return this.buildArraySerializer(serializerProvider, (ArrayType)javaType, beanDescription, bl, typeSerializer, jsonSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializerProvider serializerProvider, CollectionType collectionType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Serializers clazz2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        StdSerializer stdSerializer = null;
        Object object = this.customSerializers().iterator();
        while (object.hasNext() && (stdSerializer = (clazz2 = object.next()).findCollectionSerializer(serializationConfig, collectionType, beanDescription, typeSerializer, jsonSerializer)) == null) {
        }
        if (stdSerializer == null && (stdSerializer = this.findSerializerByAnnotations(serializerProvider, collectionType, beanDescription)) == null) {
            Type type;
            object = beanDescription.findExpectedFormat(null);
            if (object != null && ((JsonFormat.Value)object).getShape() == JsonFormat.Shape.OBJECT) {
                return null;
            }
            Class<?> clazz = collectionType.getRawClass();
            if (EnumSet.class.isAssignableFrom(clazz)) {
                type = collectionType.getContentType();
                if (!type.isEnumType()) {
                    type = null;
                }
                stdSerializer = this.buildEnumSetSerializer((JavaType)type);
            } else {
                type = collectionType.getContentType().getRawClass();
                if (this.isIndexedList(clazz)) {
                    if (type == String.class) {
                        if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
                            stdSerializer = IndexedStringListSerializer.instance;
                        }
                    } else {
                        stdSerializer = this.buildIndexedListSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
                    }
                } else if (type == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
                    stdSerializer = StringCollectionSerializer.instance;
                }
                if (stdSerializer == null) {
                    stdSerializer = this.buildCollectionSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                stdSerializer = beanSerializerModifier.modifyCollectionSerializer(serializationConfig, collectionType, beanDescription, stdSerializer);
            }
        }
        return stdSerializer;
    }

    protected boolean isIndexedList(Class<?> clazz) {
        return RandomAccess.class.isAssignableFrom(clazz);
    }

    public ContainerSerializer<?> buildIndexedListSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return new IndexedListSerializer(javaType, bl, typeSerializer, jsonSerializer);
    }

    public ContainerSerializer<?> buildCollectionSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return new CollectionSerializer(javaType, bl, typeSerializer, jsonSerializer);
    }

    public JsonSerializer<?> buildEnumSetSerializer(JavaType javaType) {
        return new EnumSetSerializer(javaType);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializerProvider serializerProvider, MapType mapType, BeanDescription beanDescription, boolean bl, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) throws JsonMappingException {
        Serializers object4;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        MapSerializer mapSerializer = null;
        Object object2 = this.customSerializers().iterator();
        while (object2.hasNext() && (mapSerializer = (object4 = object2.next()).findMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer, typeSerializer, jsonSerializer2)) == null) {
        }
        if (mapSerializer == null && (mapSerializer = this.findSerializerByAnnotations(serializerProvider, mapType, beanDescription)) == null) {
            object2 = this.findFilterId(serializationConfig, beanDescription);
            JsonIgnoreProperties.Value value = serializationConfig.getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
            Set<String> set = value == null ? null : value.findIgnoredForSerialization();
            MapSerializer mapSerializer2 = MapSerializer.construct(set, (JavaType)mapType, bl, typeSerializer, jsonSerializer, jsonSerializer2, object2);
            Object object = this.findSuppressableContentValue(serializationConfig, mapType.getContentType(), beanDescription);
            if (object != null) {
                mapSerializer2 = mapSerializer2.withContentInclusion(object);
            }
            mapSerializer = mapSerializer2;
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                mapSerializer = beanSerializerModifier.modifyMapSerializer(serializationConfig, mapType, beanDescription, mapSerializer);
            }
        }
        return mapSerializer;
    }

    protected Object findSuppressableContentValue(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonInclude.Value value = beanDescription.findPropertyInclusion(serializationConfig.getDefaultPropertyInclusion());
        if (value == null) {
            return null;
        }
        JsonInclude.Include include = value.getContentInclusion();
        switch (include) {
            case USE_DEFAULTS: {
                return null;
            }
            case NON_DEFAULT: {
                break;
            }
        }
        return include;
    }

    protected JsonSerializer<?> buildArraySerializer(SerializerProvider serializerProvider, ArrayType arrayType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Serializers object2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        JsonSerializer jsonSerializer2 = null;
        Iterator<BeanSerializerModifier> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (jsonSerializer2 = (object2 = iterator.next()).findArraySerializer(serializationConfig, arrayType, beanDescription, typeSerializer, jsonSerializer)) == null) {
        }
        if (jsonSerializer2 == null) {
            iterator = arrayType.getRawClass();
            if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
                jsonSerializer2 = String[].class == iterator ? StringArraySerializer.instance : StdArraySerializers.findStandardImpl(iterator);
            }
            if (jsonSerializer2 == null) {
                jsonSerializer2 = new ObjectArraySerializer(arrayType.getContentType(), bl, typeSerializer, jsonSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer2 = beanSerializerModifier.modifyArraySerializer(serializationConfig, arrayType, beanDescription, jsonSerializer2);
            }
        }
        return jsonSerializer2;
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl, JavaType javaType2) throws JsonMappingException {
        return new IteratorSerializer(javaType2, bl, this.createTypeSerializer(serializationConfig, javaType2));
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl, JavaType javaType2) throws JsonMappingException {
        return new IterableSerializer(javaType2, bl, this.createTypeSerializer(serializationConfig, javaType2));
    }

    protected JsonSerializer<?> buildMapEntrySerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl, JavaType javaType2, JavaType javaType3) throws JsonMappingException {
        return new MapEntrySerializer(javaType3, javaType2, javaType3, bl, this.createTypeSerializer(serializationConfig, javaType3), null);
    }

    protected JsonSerializer<?> buildEnumSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonFormat.Value value = beanDescription.findExpectedFormat(null);
        if (value != null && value.getShape() == JsonFormat.Shape.OBJECT) {
            ((BasicBeanDescription)beanDescription).removeProperty("declaringClass");
            return null;
        }
        Class<?> clazz = javaType.getRawClass();
        JsonSerializer jsonSerializer = EnumSerializer.construct(clazz, serializationConfig, beanDescription, value);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifyEnumSerializer(serializationConfig, javaType, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findKeySerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findContentSerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    protected Object findFilterId(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return serializationConfig.getAnnotationIntrospector().findFilterId(beanDescription.getClassInfo());
    }

    protected boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer) {
        if (typeSerializer != null) {
            return false;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        JsonSerialize.Typing typing = annotationIntrospector.findSerializationTyping(beanDescription.getClassInfo());
        if (typing != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            return typing == JsonSerialize.Typing.STATIC;
        }
        return serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || ClassUtil.isBogusClass(clazz2)) {
            return null;
        }
        return clazz2;
    }

    static {
        HashMap<String, Class<TokenBufferSerializer>> hashMap = new HashMap<String, Class<TokenBufferSerializer>>();
        HashMap hashMap2 = new HashMap();
        hashMap2.put(String.class.getName(), new StringSerializer());
        ToStringSerializer toStringSerializer = ToStringSerializer.instance;
        hashMap2.put(StringBuffer.class.getName(), toStringSerializer);
        hashMap2.put(StringBuilder.class.getName(), toStringSerializer);
        hashMap2.put(Character.class.getName(), toStringSerializer);
        hashMap2.put(Character.TYPE.getName(), toStringSerializer);
        NumberSerializers.addAll(hashMap2);
        hashMap2.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        hashMap2.put(Boolean.class.getName(), new BooleanSerializer(false));
        hashMap2.put(BigInteger.class.getName(), new NumberSerializer((Class<? extends Number>)BigInteger.class));
        hashMap2.put(BigDecimal.class.getName(), new NumberSerializer((Class<? extends Number>)BigDecimal.class));
        hashMap2.put(Calendar.class.getName(), CalendarSerializer.instance);
        hashMap2.put(Date.class.getName(), DateSerializer.instance);
        for (Map.Entry<Class<?>, Object> entry : StdJdkSerializers.all()) {
            Object object = entry.getValue();
            if (object instanceof JsonSerializer) {
                hashMap2.put(entry.getKey().getName(), (JsonSerializer)object);
                continue;
            }
            if (object instanceof Class) {
                Class clazz = (Class)object;
                hashMap.put(entry.getKey().getName(), clazz);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + entry.getClass().getName());
        }
        hashMap.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
        _concrete = hashMap2;
        _concreteLazy = hashMap;
    }
}

