/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class NioPathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return (Path)deserializationContext.handleUnexpectedToken(Path.class, jsonParser);
        }
        String string = jsonParser.getText();
        if (string.indexOf(58) < 0) {
            return Paths.get(string, new String[0]);
        }
        try {
            URI uRI = new URI(string);
            return Paths.get(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return (Path)deserializationContext.handleInstantiationProblem(this.handledType(), string, uRISyntaxException);
        }
    }
}

