/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T> {
    protected ContainerDeserializerBase(JavaType javaType) {
        super(javaType);
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        JsonDeserializer<Object> jsonDeserializer = this.getContentDeserializer();
        if (jsonDeserializer == null) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': type: container deserializer of type " + this.getClass().getName() + " returned null for 'getContentDeserializer()'");
        }
        return jsonDeserializer.findBackReference(string);
    }

    public abstract JavaType getContentType();

    public abstract JsonDeserializer<Object> getContentDeserializer();

    protected void wrapAndThrow(Throwable throwable, Object object, String string) throws IOException {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException && !(throwable instanceof JsonMappingException)) {
            throw (IOException)throwable;
        }
        if (string == null) {
            string = "N/A";
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }
}

