/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.math.BigDecimal;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    public BaseNodeDeserializer(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Deprecated
    protected void _reportProblem(JsonParser jsonParser, String string) throws JsonMappingException {
        throw JsonMappingException.from(jsonParser, string);
    }

    protected void _handleDuplicateField(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws JsonProcessingException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportMappingException("Duplicate field '%s' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled", string);
        }
    }

    protected final ObjectNode deserializeObject(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        Object object;
        String string;
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.getCurrentToken();
            if (object == JsonToken.END_OBJECT) {
                return objectNode;
            }
            if (object != JsonToken.FIELD_NAME) {
                return (ObjectNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
            }
            string = jsonParser.getCurrentName();
        }
        while (string != null) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                throw deserializationContext.mappingException("Unexpected end-of-input when binding data into ObjectNode");
            }
            switch (jsonToken.id()) {
                case 1: {
                    object = this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 3: {
                    object = this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 12: {
                    object = this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 6: {
                    object = jsonNodeFactory.textNode(jsonParser.getText());
                    break;
                }
                case 7: {
                    object = this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 9: {
                    object = jsonNodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    object = jsonNodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    object = jsonNodeFactory.nullNode();
                    break;
                }
                default: {
                    object = this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory);
                }
            }
            JsonNode jsonNode = objectNode.replace(string, (JsonNode)object);
            if (jsonNode != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode, (JsonNode)object);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final ArrayNode deserializeArray(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        ArrayNode arrayNode = jsonNodeFactory.arrayNode();
        block11: while (true) {
            JsonToken jsonToken = jsonParser.nextToken();
            switch (jsonToken.id()) {
                case 1: {
                    arrayNode.add(this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 3: {
                    arrayNode.add(this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 4: {
                    return arrayNode;
                }
                case 12: {
                    arrayNode.add(this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 6: {
                    arrayNode.add(jsonNodeFactory.textNode(jsonParser.getText()));
                    continue block11;
                }
                case 7: {
                    arrayNode.add(this._fromInt(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 9: {
                    arrayNode.add(jsonNodeFactory.booleanNode(true));
                    continue block11;
                }
                case 10: {
                    arrayNode.add(jsonNodeFactory.booleanNode(false));
                    continue block11;
                }
                case 11: {
                    arrayNode.add(jsonNodeFactory.nullNode());
                    continue block11;
                }
            }
            arrayNode.add(this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                return this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 3: {
                return this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        int n = deserializationContext.getDeserializationFeatures();
        JsonParser.NumberType numberType = (n & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n) ? JsonParser.NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            double d = jsonParser.getDoubleValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return jsonNodeFactory.numberNode(d);
            }
            return jsonNodeFactory.numberNode(BigDecimal.valueOf(d));
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        Object object = jsonParser.getEmbeddedObject();
        if (object == null) {
            return jsonNodeFactory.nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return jsonNodeFactory.binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return jsonNodeFactory.rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return jsonNodeFactory.pojoNode(object);
    }
}

