/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class SettableAnyProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _setter;
    final boolean _setterIsField;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._setter = annotatedMember;
        this._type = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._setterIsField = annotatedMember instanceof AnnotatedField;
    }

    public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
        return new SettableAnyProperty(this._property, this._setter, this._type, jsonDeserializer, this._valueTypeDeserializer);
    }

    protected SettableAnyProperty(SettableAnyProperty settableAnyProperty) {
        this._property = settableAnyProperty._property;
        this._setter = settableAnyProperty._setter;
        this._type = settableAnyProperty._type;
        this._valueDeserializer = settableAnyProperty._valueDeserializer;
        this._valueTypeDeserializer = settableAnyProperty._valueTypeDeserializer;
        this._setterIsField = settableAnyProperty._setterIsField;
    }

    Object readResolve() {
        if (this._setter == null || this._setter.getAnnotated() == null) {
            throw new IllegalArgumentException("Missing method (broken JDK (de)serialization?)");
        }
        return this;
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
        try {
            this.set(object, string, this.deserialize(jsonParser, deserializationContext));
        }
        catch (UnresolvedForwardReference unresolvedForwardReference) {
            if (this._valueDeserializer.getObjectIdReader() == null) {
                throw JsonMappingException.from(jsonParser, "Unresolved forward reference but no identity info.", (Throwable)unresolvedForwardReference);
            }
            AnySetterReferring anySetterReferring = new AnySetterReferring(this, unresolvedForwardReference, this._type.getRawClass(), object, string);
            unresolvedForwardReference.getRoid().appendReferring(anySetterReferring);
        }
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return this._valueDeserializer.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public void set(Object object, String string, Object object2) throws IOException {
        try {
            if (this._setterIsField) {
                AnnotatedField annotatedField = (AnnotatedField)this._setter;
                Map map = (Map)annotatedField.getValue(object);
                if (map != null) {
                    map.put(string, object2);
                }
            } else {
                ((AnnotatedMethod)this._setter).callOnWith(object, string, object2);
            }
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, string, object2);
        }
    }

    protected void _throwAsIOE(Exception exception, String string, Object object) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string2 = object == null ? "[NULL]" : object.getClass().getName();
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing \"any\" property '").append(string);
            stringBuilder.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            stringBuilder.append("; actual type: ").append(string2).append(")");
            String string3 = exception.getMessage();
            if (string3 != null) {
                stringBuilder.append(", problem: ").append(string3);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(null, stringBuilder.toString(), (Throwable)exception);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throw new JsonMappingException(null, throwable.getMessage(), throwable);
    }

    private String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }

    private static class AnySetterReferring
    extends ReadableObjectId.Referring {
        private final SettableAnyProperty _parent;
        private final Object _pojo;
        private final String _propName;

        public AnySetterReferring(SettableAnyProperty settableAnyProperty, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz, Object object, String string) {
            super(unresolvedForwardReference, clazz);
            this._parent = settableAnyProperty;
            this._pojo = object;
            this._propName = string;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            if (!this.hasId(object)) {
                throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object.toString() + "] that wasn't previously registered.");
            }
            this._parent.set(this._pojo, this._propName, object2);
        }
    }
}

