/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._backRefProperties = map;
        Class<Object> clazz = this._baseType.getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        this._acceptBoolean = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
    }

    protected AbstractDeserializer(BeanDescription beanDescription) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = null;
        this._backRefProperties = null;
        Class<Object> clazz = this._baseType.getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        this._acceptBoolean = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDescription) {
        return new AbstractDeserializer(beanDescription);
    }

    @Override
    public Class<?> handledType() {
        return this._baseType.getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        return this._backRefProperties == null ? null : this._backRefProperties.get(string);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        Object object;
        if (this._objectIdReader != null && (object = jsonParser.getCurrentToken()) != null) {
            if (object.isScalarValue()) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
            if (object == JsonToken.START_OBJECT) {
                object = jsonParser.nextToken();
            }
            if (object == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(jsonParser.getCurrentName(), jsonParser)) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
        }
        if ((object = this._deserializeIfNatural(jsonParser, deserializationContext)) != null) {
            return object;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return deserializationContext.handleMissingInstantiator(this._baseType.getRawClass(), jsonParser, "abstract types either need to be mapped to concrete types, have custom deserializer, or contain additional type information", new Object[0]);
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                if (!this._acceptString) break;
                return jsonParser.getText();
            }
            case 7: {
                if (!this._acceptInt) break;
                return jsonParser.getIntValue();
            }
            case 8: {
                if (!this._acceptDouble) break;
                return jsonParser.getDoubleValue();
            }
            case 9: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case 10: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object = this._objectIdReader.readObjectReference(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator, this._objectIdReader.resolver);
        Object object2 = readableObjectId.resolve();
        if (object2 == null) {
            throw new UnresolvedForwardReference(jsonParser, "Could not resolve Object Id [" + object + "] -- unresolved forward-reference?", jsonParser.getCurrentLocation(), readableObjectId);
        }
        return object2;
    }
}

