/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JsonMappingException
extends JsonProcessingException {
    private static final long serialVersionUID = 1L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;
    protected transient Closeable _processor;

    @Deprecated
    public JsonMappingException(String string) {
        super(string);
    }

    @Deprecated
    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public JsonMappingException(Closeable closeable, String string) {
        super(string);
        this._processor = closeable;
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, Throwable throwable) {
        super(string, throwable);
        this._processor = closeable;
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
        this._processor = closeable;
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(jsonParser, string);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonParser, string, throwable);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string) {
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)null);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonGenerator, string, throwable);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string) {
        return new JsonMappingException(deserializationContext.getParser(), string);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)deserializationContext.getParser(), string, throwable);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string) {
        return new JsonMappingException(serializerProvider.getGenerator(), string);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)serializerProvider.getGenerator(), string, throwable);
    }

    public static JsonMappingException fromUnexpectedIOE(IOException iOException) {
        return new JsonMappingException(null, String.format("Unexpected IOException (of type %s): %s", iOException.getClass().getName(), iOException.getMessage()));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, n));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Reference reference) {
        JsonMappingException jsonMappingException;
        if (throwable instanceof JsonMappingException) {
            jsonMappingException = (JsonMappingException)throwable;
        } else {
            Object object;
            String string = throwable.getMessage();
            if (string == null || string.length() == 0) {
                string = "(was " + throwable.getClass().getName() + ")";
            }
            Closeable closeable = null;
            if (throwable instanceof JsonProcessingException && (object = ((JsonProcessingException)throwable).getProcessor()) instanceof Closeable) {
                closeable = (Closeable)object;
            }
            jsonMappingException = new JsonMappingException(closeable, string, throwable);
        }
        jsonMappingException.prependPath(reference);
        return jsonMappingException;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    public void prependPath(Object object, String string) {
        Reference reference = new Reference(object, string);
        this.prependPath(reference);
    }

    public void prependPath(Object object, int n) {
        Reference reference = new Reference(object, n);
        this.prependPath(reference);
    }

    public void prependPath(Reference reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(reference);
        }
    }

    @Override
    public Object getProcessor() {
        return this._processor;
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String string = super.getMessage();
        if (this._path == null) {
            return string;
        }
        StringBuilder stringBuilder = string == null ? new StringBuilder() : new StringBuilder(string);
        stringBuilder.append(" (through reference chain: ");
        stringBuilder = this.getPathReference(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        if (this._path == null) {
            return;
        }
        Iterator iterator = this._path.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((Reference)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 2L;
        protected transient Object _from;
        protected String _fieldName;
        protected int _index = -1;
        protected String _desc;

        protected Reference() {
        }

        public Reference(Object object) {
            this._from = object;
        }

        public Reference(Object object, String string) {
            this._from = object;
            if (string == null) {
                throw new NullPointerException("Can not pass null fieldName");
            }
            this._fieldName = string;
        }

        public Reference(Object object, int n) {
            this._from = object;
            this._index = n;
        }

        void setFieldName(String string) {
            this._fieldName = string;
        }

        void setIndex(int n) {
            this._index = n;
        }

        void setDescription(String string) {
            this._desc = string;
        }

        @JsonIgnore
        public Object getFrom() {
            return this._from;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getIndex() {
            return this._index;
        }

        public String getDescription() {
            if (this._desc == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this._from == null) {
                    stringBuilder.append("UNKNOWN");
                } else {
                    Class<?> clazz = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
                    String string = ClassUtil.getPackageName(clazz);
                    if (string != null) {
                        stringBuilder.append(string);
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(clazz.getSimpleName());
                }
                stringBuilder.append('[');
                if (this._fieldName != null) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this._fieldName);
                    stringBuilder.append('\"');
                } else if (this._index >= 0) {
                    stringBuilder.append(this._index);
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append(']');
                this._desc = stringBuilder.toString();
            }
            return this._desc;
        }

        public String toString() {
            return this.getDescription();
        }

        Object writeReplace() {
            this.getDescription();
            return this;
        }
    }
}

