/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LinkedNode;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ERROR_STR_LEN = 500;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    protected DeserializationContext(DeserializerFactory deserializerFactory) {
        this(deserializerFactory, null);
    }

    protected DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        if (deserializerFactory == null) {
            throw new IllegalArgumentException("Can not pass null DeserializerFactory");
        }
        this._factory = deserializerFactory;
        this._cache = deserializerCache == null ? new DeserializerCache() : deserializerCache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = deserializationConfig.getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
        this._attributes = deserializationConfig.getAttributes();
    }

    protected DeserializationContext(DeserializationContext deserializationContext) {
        this._cache = new DeserializerCache();
        this._factory = deserializationContext._factory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._view = deserializationContext._view;
        this._injectableValues = null;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._config.getDefaultPropertyFormat(clazz);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public DeserializationContext setAttribute(Object object, Object object2) {
        this._attributes = this._attributes.withPerCallAttribute(object, object2);
        return this;
    }

    public JavaType getContextualType() {
        return this._currentType == null ? null : this._currentType.value();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int n) {
        return (this._featureFlags & n) == n;
    }

    public final boolean hasSomeOfFeatures(int n) {
        return (this._featureFlags & n) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) {
        if (this._injectableValues == null) {
            throw new IllegalStateException("No 'injectableValues' configured, can not inject value with id [" + object + "]");
        }
        return this._injectableValues.findInjectableValue(object, this, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public boolean hasValueDeserializerFor(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        try {
            return this._cache.hasValueDeserializerFor(this, this._factory, javaType);
        }
        catch (JsonMappingException jsonMappingException) {
            if (atomicReference != null) {
                atomicReference.set(jsonMappingException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer != null) {
            jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType javaType) throws JsonMappingException {
        return this._cache.findValueDeserializer(this, this._factory, javaType);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, null, javaType);
        TypeDeserializer typeDeserializer = this._factory.findTypeDeserializer(this._config, javaType);
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(null);
            return new TypeWrappedDeserializer(typeDeserializer, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer = this._cache.findKeyDeserializer(this, this._factory, javaType);
        if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(this, beanProperty);
        }
        return keyDeserializer;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> clazz) {
        return this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        return this.getTypeFactory().findClass(string);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            objectBuffer = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    @Deprecated
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty) throws JsonMappingException {
        return this.handlePrimaryContextualization(jsonDeserializer, beanProperty, TypeFactory.unknownType());
    }

    @Deprecated
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
        }
        return jsonDeserializer;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            DateFormat dateFormat = this.getDateFormat();
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", string, parseException.getMessage()));
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.readValue(jsonParser, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            this.reportMappingException("Could not find JsonDeserializer for type %s", javaType);
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, Class<T> clazz) throws IOException {
        return this.readPropertyValue(jsonParser, beanProperty, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findContextualValueDeserializer(javaType, beanProperty);
        if (jsonDeserializer == null) {
            String string = beanProperty == null ? "NULL" : "'" + beanProperty.getName() + "'";
            this.reportMappingException("Could not find JsonDeserializer for type %s (via property %s)", javaType, string);
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public boolean handleUnknownProperty(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Object object, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            if (!linkedNode.value().handleUnknownProperty(this, jsonParser, jsonDeserializer, object, string)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            jsonParser.skipChildren();
            return true;
        }
        Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
    }

    public Object handleWeirdKey(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        if (objectArray.length > 0) {
            string2 = String.format(string2, objectArray);
        }
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdKey(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdKeyException(clazz, string, string2);
    }

    public Object handleWeirdStringValue(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        if (objectArray.length > 0) {
            string2 = String.format(string2, objectArray);
        }
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdStringValue(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdStringException(string, clazz, string2);
    }

    public Object handleWeirdNumberValue(Class<?> clazz, Number number, String string, Object ... objectArray) throws IOException {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdNumberValue(this, clazz, number, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.weirdNumberException(number, clazz, String.format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdNumberException(number, clazz, string);
    }

    public Object handleMissingInstantiator(Class<?> clazz, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleMissingInstantiator(this, clazz, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.instantiationException(clazz, String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.instantiationException(clazz, string);
    }

    public Object handleInstantiationProblem(Class<?> clazz, Object object, Throwable throwable) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleInstantiationProblem(this, clazz, object, throwable);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 == null || clazz.isInstance(object2)) {
                return object2;
            }
            throw this.instantiationException(clazz, String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", clazz, object2.getClass()));
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw this.instantiationException(clazz, throwable);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonParser jsonParser) throws IOException {
        return this.handleUnexpectedToken(clazz, jsonParser.getCurrentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleUnexpectedToken(this, clazz, jsonToken, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            this.reportMappingException("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", clazz, object.getClass());
        }
        if (string == null) {
            string = jsonToken == null ? String.format("Unexpected end-of-input when binding data into %s", this._calcName(clazz)) : String.format("Can not deserialize instance of %s out of %s token", new Object[]{this._calcName(clazz), jsonToken});
        }
        this.reportMappingException(string, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType javaType, String string, TypeIdResolver typeIdResolver, String string2) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleUnknownTypeId(this, javaType, string, typeIdResolver, string2);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.unknownTypeIdException(javaType, string, "problem handler tried to resolve into non-subtype: " + javaType2);
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.unknownTypeIdException(javaType, string, string2);
    }

    public void reportWrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        if (string != null && objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw this.wrongTokenException(jsonParser, jsonToken, string);
    }

    @Deprecated
    public void reportUnknownProperty(Object object, String string, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            return;
        }
        Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
    }

    public void reportMappingException(String string, Object ... objectArray) throws JsonMappingException {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw JsonMappingException.from(this.getParser(), string);
    }

    public void reportMissingContent(String string, Object ... objectArray) throws JsonMappingException {
        if (string == null) {
            string = "No content to map due to end-of-input";
        } else if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw JsonMappingException.from(this.getParser(), string);
    }

    public void reportUnresolvedObjectId(ObjectIdReader objectIdReader, Object object) throws JsonMappingException {
        String string = String.format("No Object Id found for an instance of %s, to assign to property '%s'", object.getClass().getName(), objectIdReader.propertyName);
        throw JsonMappingException.from(this.getParser(), string);
    }

    public JsonMappingException mappingException(String string) {
        return JsonMappingException.from(this.getParser(), string);
    }

    public JsonMappingException mappingException(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        return JsonMappingException.from(this.getParser(), string);
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz) {
        return this.mappingException(clazz, this._parser.getCurrentToken());
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz, JsonToken jsonToken) {
        String string = jsonToken == null ? "<end of input>" : String.format("%s token", new Object[]{jsonToken});
        return JsonMappingException.from(this._parser, String.format("Can not deserialize instance of %s out of %s", this._calcName(clazz), string));
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string) {
        String string2 = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.getCurrentToken(), jsonToken});
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return JsonMappingException.from(jsonParser, string2);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize Map key of type %s from String %s: %s", clazz.getName(), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize value of type %s from String %s: %s", clazz.getName(), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize value of type %s from number %s: %s", clazz.getName(), String.valueOf(number), string), number, clazz);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        return JsonMappingException.from(this._parser, String.format("Can not construct instance of %s, problem: %s", clazz.getName(), throwable.getMessage()), throwable);
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        return JsonMappingException.from(this._parser, String.format("Can not construct instance of %s: %s", clazz.getName(), string));
    }

    public JsonMappingException unknownTypeIdException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' into a subtype of %s", string, javaType);
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        return InvalidTypeIdException.from(this._parser, string3, javaType, string);
    }

    @Deprecated
    public JsonMappingException unknownTypeException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' into a subtype of %s", string, javaType);
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        return JsonMappingException.from(this._parser, string3);
    }

    @Deprecated
    public JsonMappingException endOfInputException(Class<?> clazz) {
        return JsonMappingException.from(this._parser, "Unexpected end-of-input when trying to deserialize a " + clazz.getName());
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }

    protected String determineClassName(Object object) {
        return ClassUtil.getClassDescription(object);
    }

    protected String _calcName(Class<?> clazz) {
        if (clazz.isArray()) {
            return this._calcName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception exception) {
            return "[N/A]";
        }
    }

    protected String _desc(String string) {
        if (string == null) {
            return "[N/A]";
        }
        if (string.length() > 500) {
            string = string.substring(0, 500) + "]...[" + string.substring(string.length() - 500);
        }
        return string;
    }

    protected String _quotedString(String string) {
        if (string == null) {
            return "[N/A]";
        }
        if (string.length() > 500) {
            return String.format("\"%s]...[%s\"", string.substring(0, 500), string.substring(string.length() - 500));
        }
        return "\"" + string + "\"";
    }
}

