/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonInclude {
    public Include value() default Include.ALWAYS;

    public Include content() default Include.ALWAYS;

    public static class Value
    implements JacksonAnnotationValue<JsonInclude>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(Include.USE_DEFAULTS, Include.USE_DEFAULTS);
        protected final Include _valueInclusion;
        protected final Include _contentInclusion;

        public Value(JsonInclude jsonInclude) {
            this(jsonInclude.value(), jsonInclude.content());
        }

        protected Value(Include include, Include include2) {
            this._valueInclusion = include == null ? Include.USE_DEFAULTS : include;
            this._contentInclusion = include2 == null ? Include.USE_DEFAULTS : include2;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            return value == null ? value2 : value.withOverrides(value2);
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                value = value == null ? value2 : value.withOverrides(value2);
            }
            return value;
        }

        protected Object readResolve() {
            if (this._valueInclusion == Include.USE_DEFAULTS && this._contentInclusion == Include.USE_DEFAULTS) {
                return EMPTY;
            }
            return this;
        }

        public Value withOverrides(Value value) {
            boolean bl;
            if (value == null || value == EMPTY) {
                return this;
            }
            Include include = value._valueInclusion;
            Include include2 = value._contentInclusion;
            boolean bl2 = include != this._valueInclusion && include != Include.USE_DEFAULTS;
            boolean bl3 = bl = include2 != this._contentInclusion && include2 != Include.USE_DEFAULTS;
            if (bl2) {
                if (bl) {
                    return new Value(include, include2);
                }
                return new Value(include, this._contentInclusion);
            }
            if (bl) {
                return new Value(this._valueInclusion, include2);
            }
            return this;
        }

        public static Value construct(Include include, Include include2) {
            if (!(include != Include.USE_DEFAULTS && include != null || include2 != Include.USE_DEFAULTS && include2 != null)) {
                return EMPTY;
            }
            return new Value(include, include2);
        }

        public static Value from(JsonInclude jsonInclude) {
            if (jsonInclude == null) {
                return null;
            }
            Include include = jsonInclude.value();
            Include include2 = jsonInclude.content();
            if (include == Include.USE_DEFAULTS && include2 == Include.USE_DEFAULTS) {
                return EMPTY;
            }
            return new Value(include, include2);
        }

        public Value withValueInclusion(Include include) {
            return include == this._valueInclusion ? this : new Value(include, this._contentInclusion);
        }

        public Value withContentInclusion(Include include) {
            return include == this._contentInclusion ? this : new Value(this._valueInclusion, include);
        }

        @Override
        public Class<JsonInclude> valueFor() {
            return JsonInclude.class;
        }

        public Include getValueInclusion() {
            return this._valueInclusion;
        }

        public Include getContentInclusion() {
            return this._contentInclusion;
        }

        public String toString() {
            return String.format("[value=%s,content=%s]", new Object[]{this._valueInclusion, this._contentInclusion});
        }

        public int hashCode() {
            return (this._valueInclusion.hashCode() << 2) + this._contentInclusion.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Value value = (Value)object;
            return value._valueInclusion == this._valueInclusion && value._contentInclusion == this._contentInclusion;
        }
    }

    public static enum Include {
        ALWAYS,
        NON_NULL,
        NON_ABSENT,
        NON_EMPTY,
        NON_DEFAULT,
        USE_DEFAULTS;

    }
}

