/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class XMLPropertyListWriter {
    public static void write(NSObject nSObject, File file) throws IOException {
        Objects.requireNonNull(nSObject, "The root object is null.");
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        XMLPropertyListWriter.write(nSObject, file.toPath());
    }

    public static void write(NSObject nSObject, Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            XMLPropertyListWriter.write(nSObject, outputStream);
        }
    }

    public static void write(NSObject nSObject, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(nSObject, "The root object is null.");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        outputStreamWriter.write(nSObject.toXMLPropertyList());
        outputStreamWriter.flush();
    }
}

