/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

class ByteOrderMarkFilterInputStream
extends FilterInputStream {
    private final boolean closeStream;
    private boolean readingBom = true;
    private final Queue<Integer> consumedBytes = new LinkedList<Integer>();

    public ByteOrderMarkFilterInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.closeStream = bl;
    }

    @Override
    public int read() throws IOException {
        if (this.readingBom) {
            int n;
            ByteOrderMarkReader byteOrderMarkReader = new ByteOrderMarkReader();
            do {
                n = super.read();
                this.consumedBytes.add(n);
                this.readingBom = byteOrderMarkReader.readByte(n);
            } while (this.readingBom);
            if (byteOrderMarkReader.getDetectedCharset() != null) {
                this.consumedBytes.clear();
                return n;
            }
        }
        if (this.consumedBytes.size() > 0) {
            return this.consumedBytes.poll();
        }
        return super.read();
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            super.close();
        }
    }
}

