/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIILocationInformation;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Objects;

public final class ASCIIPropertyListParser {
    public static final char WHITESPACE_SPACE = ' ';
    public static final char WHITESPACE_TAB = '\t';
    public static final char WHITESPACE_NEWLINE = '\n';
    public static final char WHITESPACE_CARRIAGE_RETURN = '\r';
    public static final char ARRAY_BEGIN_TOKEN = '(';
    public static final char ARRAY_END_TOKEN = ')';
    public static final char ARRAY_ITEM_DELIMITER_TOKEN = ',';
    public static final char DICTIONARY_BEGIN_TOKEN = '{';
    public static final char DICTIONARY_END_TOKEN = '}';
    public static final char DICTIONARY_ASSIGN_TOKEN = '=';
    public static final char DICTIONARY_ITEM_DELIMITER_TOKEN = ';';
    public static final char QUOTEDSTRING_BEGIN_TOKEN = '\"';
    public static final char QUOTEDSTRING_END_TOKEN = '\"';
    public static final char QUOTEDSTRING_ESCAPE_TOKEN = '\\';
    public static final char DATA_BEGIN_TOKEN = '<';
    public static final char DATA_END_TOKEN = '>';
    public static final char DATA_BASE64_BEGIN_TOKEN = '[';
    public static final char DATA_BASE64_END_TOKEN = ']';
    public static final char DATA_GSOBJECT_BEGIN_TOKEN = '*';
    public static final char DATA_GSDATE_BEGIN_TOKEN = 'D';
    public static final char DATA_GSBOOL_BEGIN_TOKEN = 'B';
    public static final char DATA_GSBOOL_TRUE_TOKEN = 'Y';
    public static final char DATA_GSBOOL_FALSE_TOKEN = 'N';
    public static final char DATA_GSINT_BEGIN_TOKEN = 'I';
    public static final char DATA_GSREAL_BEGIN_TOKEN = 'R';
    public static final char DATE_DATE_FIELD_DELIMITER = '-';
    public static final char DATE_TIME_FIELD_DELIMITER = ':';
    public static final char DATE_GS_DATE_TIME_DELIMITER = ' ';
    public static final char DATE_APPLE_DATE_TIME_DELIMITER = 'T';
    public static final char DATE_APPLE_END_TOKEN = 'Z';
    public static final char COMMENT_BEGIN_TOKEN = '/';
    public static final char MULTILINE_COMMENT_SECOND_TOKEN = '*';
    public static final char SINGLELINE_COMMENT_SECOND_TOKEN = '/';
    public static final char MULTILINE_COMMENT_END_TOKEN = '/';
    private final char[] data;
    private int index;
    private int lineNo = 1;
    private int lineBeginning = -1;

    private ASCIIPropertyListParser(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(new String(byArray, string).toCharArray());
    }

    private ASCIIPropertyListParser(char[] cArray) {
        this.data = cArray;
    }

    public static NSObject parse(File file) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(file.toPath());
    }

    public static NSObject parse(File file, String string) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(file.toPath(), string);
    }

    public static NSObject parse(Path path, String string) throws IOException, ParseException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(inputStream, string);
            return nSObject;
        }
    }

    public static NSObject parse(Path path) throws IOException, ParseException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(inputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream inputStream) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(inputStream));
    }

    public static NSObject parse(InputStream inputStream, String string) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(inputStream), string);
    }

    public static NSObject parse(Reader reader) throws ParseException, IOException {
        int n;
        Objects.requireNonNull(reader, "The specified reader is null");
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        ASCIIPropertyListParser aSCIIPropertyListParser = new ASCIIPropertyListParser(charArrayWriter.toCharArray());
        return aSCIIPropertyListParser.parse();
    }

    public static NSObject parse(String string) throws ParseException {
        ASCIIPropertyListParser aSCIIPropertyListParser = new ASCIIPropertyListParser(string.toCharArray());
        return aSCIIPropertyListParser.parse();
    }

    public static NSObject parse(byte[] byArray) throws ParseException {
        String string = ByteOrderMarkReader.detect(byArray);
        if (string == null) {
            string = "UTF-8";
        }
        try {
            return ASCIIPropertyListParser.parse(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported property list encoding (" + string + "): " + unsupportedEncodingException.getMessage());
        }
    }

    public static NSObject parse(byte[] byArray, String string) throws ParseException, UnsupportedEncodingException {
        ASCIIPropertyListParser aSCIIPropertyListParser = new ASCIIPropertyListParser(byArray, string);
        return aSCIIPropertyListParser.parse();
    }

    private boolean acceptSequence(char ... cArray) {
        if (this.index + cArray.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (this.data[this.index + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    private boolean accept(char ... cArray) {
        boolean bl = false;
        if (this.index < this.data.length) {
            for (char c : cArray) {
                if (this.data[this.index] != c) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean accept(char c) {
        return this.index < this.data.length && this.data[this.index] == c;
    }

    private void expect(char ... cArray) throws ParseException {
        if (!this.accept(cArray)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected '").append(cArray[0]).append("'");
            for (int i = 1; i < cArray.length; ++i) {
                stringBuilder.append(" or '").append(cArray[i]).append("'");
            }
            if (this.index < this.data.length) {
                stringBuilder.append(" but found '").append(this.data[this.index]).append("'");
            } else {
                stringBuilder.append(" but reached end of input");
            }
            throw this.createParseException(stringBuilder.toString(), this.index);
        }
    }

    private void expect(char c) throws ParseException {
        if (!this.accept(c)) {
            throw this.createParseException(this.index < this.data.length ? "Expected '" + c + "' but found '" + this.data[this.index] + "'" : "Expected '" + c + "' but reached end of input", this.index);
        }
    }

    private void read(char c) throws ParseException {
        this.expect(c);
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    private void skip(int n) {
        this.index += n;
    }

    private void trackLineBreak() {
        if (this.data[this.index] == '\n') {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
        if (this.data[this.index] == '\r' && (this.index + 1 >= this.data.length || this.data[this.index + 1] != '\n')) {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
    }

    private void skipWhitespacesAndComments() {
        boolean bl;
        do {
            bl = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.trackLineBreak();
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
                bl = true;
                continue;
            }
            if (!this.acceptSequence('/', '*')) continue;
            this.skip(2);
            while (this.index < this.data.length) {
                if (this.acceptSequence('*', '/')) {
                    this.skip(2);
                    break;
                }
                this.trackLineBreak();
                this.skip();
            }
            bl = true;
        } while (bl);
    }

    private String readInputUntil(char ... cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.index < this.data.length && !this.accept(cArray)) {
            stringBuilder.append(this.data[this.index]);
            this.skip();
        }
        return stringBuilder.toString();
    }

    private String readInputUntil(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.index < this.data.length && !this.accept(c)) {
            stringBuilder.append(this.data[this.index]);
            this.trackLineBreak();
            this.skip();
        }
        return stringBuilder.toString();
    }

    public NSObject parse() throws ParseException {
        this.index = 0;
        if (this.data.length == 0) {
            throw new ParseException("The property list is empty.", 0);
        }
        if (this.data[0] == '\ufeff') {
            this.skip(1);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.createParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    private NSObject parseObject() throws ParseException {
        NSObject nSObject;
        ASCIILocationInformation aSCIILocationInformation = new ASCIILocationInformation(this.index, this.lineNo, this.index - this.lineBeginning);
        switch (this.data[this.index]) {
            case '(': {
                nSObject = this.parseArray();
                break;
            }
            case '{': {
                nSObject = this.parseDictionary();
                break;
            }
            case '<': {
                nSObject = this.parseData();
                break;
            }
            case '\"': {
                String string = this.parseQuotedString();
                if (string.length() == 20 && string.charAt(4) == '-') {
                    try {
                        nSObject = new NSDate(string);
                    }
                    catch (Exception exception) {
                        nSObject = new NSString(string);
                    }
                    break;
                }
                nSObject = new NSString(string);
                break;
            }
            default: {
                nSObject = this.data[this.index] >= '0' && this.data[this.index] <= '9' ? this.parseDateString() : new NSString(this.parseString());
            }
        }
        if (nSObject != null) {
            nSObject.setLocationInformation(aSCIILocationInformation);
        }
        return nSObject;
    }

    private NSArray parseArray() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        LinkedList<NSObject> linkedList = new LinkedList<NSObject>();
        while (!this.accept(')')) {
            linkedList.add(this.parseObject());
            this.skipWhitespacesAndComments();
            if (!this.accept(',')) break;
            this.skip();
            this.skipWhitespacesAndComments();
        }
        this.read(')');
        return new NSArray(linkedList.toArray(new NSObject[0]));
    }

    private NSDictionary parseDictionary() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        NSDictionary nSDictionary = new NSDictionary();
        while (!this.accept('}')) {
            String string = this.accept('\"') ? this.parseQuotedString() : this.parseString();
            this.skipWhitespacesAndComments();
            this.read('=');
            this.skipWhitespacesAndComments();
            NSObject nSObject = this.parseObject();
            nSDictionary.put(string, nSObject);
            this.skipWhitespacesAndComments();
            this.read(';');
            this.skipWhitespacesAndComments();
        }
        this.skip();
        return nSDictionary;
    }

    private NSObject parseData() throws ParseException {
        int n = this.index;
        NSObject nSObject = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                nSObject = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                String string = this.readInputUntil('>');
                nSObject = new NSDate(string);
            } else if (this.accept('I', 'R')) {
                this.skip();
                String string = this.readInputUntil('>');
                try {
                    nSObject = new NSNumber(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.createParseException("The NSNumber object has an invalid format.", n);
                }
            }
            this.read('>');
        } else if (this.accept('[')) {
            this.skip();
            String string = this.readInputUntil(']');
            try {
                nSObject = new NSData(string);
            }
            catch (IOException iOException) {
                throw this.createParseException("The NSData object could be parsed.", n);
            }
            this.skip();
            this.read('>');
        } else {
            String string = this.readInputUntil('>');
            string = string.replaceAll("\\s+", "");
            int n2 = string.length() / 2;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < byArray.length) {
                int n5 = Character.digit(string.charAt(n4), 16);
                int n6 = Character.digit(string.charAt(n4 + 1), 16);
                if (n5 == -1 || n6 == -1) {
                    throw this.createParseException("The NSData object contains non-hexadecimal characters.", n);
                }
                byArray[n3] = (byte)(n5 << 4 | n6);
                ++n3;
                n4 += 2;
            }
            nSObject = new NSData(byArray);
            this.skip();
        }
        return nSObject;
    }

    private NSObject parseDateString() {
        String string = this.parseString();
        if (string.length() > 4 && string.charAt(4) == '-') {
            try {
                return new NSDate(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NSString(string);
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    private String parseQuotedString() throws ParseException {
        int n = this.index;
        this.skip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        EscapeSequenceHandler escapeSequenceHandler = null;
        while (this.data[this.index] != '\"' || escapeSequenceHandler != null) {
            char c = this.data[this.index];
            if (escapeSequenceHandler != null) {
                if (escapeSequenceHandler.handleNextChar(c)) {
                    escapeSequenceHandler = null;
                }
            } else if (c == '\\') {
                escapeSequenceHandler = new EscapeSequenceHandler(stringBuilder);
            } else {
                stringBuilder.append(c);
            }
            this.trackLineBreak();
            this.skip();
        }
        if (escapeSequenceHandler != null) {
            escapeSequenceHandler.handleEndOfString();
        }
        this.skip();
        return stringBuilder.toString();
    }

    private ParseException createParseException(String string) {
        return this.createParseException(string, this.index);
    }

    private ParseException createParseException(String string, int n) {
        return new ParseException(string + " (" + this.lineNo + ":" + (n - this.lineBeginning) + ")", n);
    }

    private class EscapeSequenceHandler {
        private final int startIndex;
        private final StringBuilder stringBuilder;
        private int unicodeReferenceRadix = 0;
        private StringBuilder unicodeReference;

        public EscapeSequenceHandler(StringBuilder stringBuilder) {
            this.startIndex = ASCIIPropertyListParser.this.index;
            this.stringBuilder = stringBuilder;
        }

        public boolean handleNextChar(char c) throws ParseException {
            switch (this.unicodeReferenceRadix) {
                case 8: {
                    return this.handleNextCharOfOctalEscapeSequence(c);
                }
                case 16: {
                    return this.handleNextCharOfHexEscapeSequence(c);
                }
            }
            return this.handleFirstChar(c);
        }

        public void handleEndOfString() throws ParseException {
            String string = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
            throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an incomplete escape sequence: " + string, this.startIndex);
        }

        private boolean handleFirstChar(char c) throws ParseException {
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    this.stringBuilder.append(c);
                    return true;
                }
                case 'b': {
                    this.stringBuilder.append('\b');
                    return true;
                }
                case 'n': {
                    this.stringBuilder.append('\n');
                    return true;
                }
                case 'r': {
                    this.stringBuilder.append('\r');
                    return true;
                }
                case 't': {
                    this.stringBuilder.append('\t');
                    return true;
                }
                case 'U': 
                case 'u': {
                    this.unicodeReferenceRadix = 16;
                    this.unicodeReference = new StringBuilder(4);
                    return false;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.unicodeReferenceRadix = 8;
                    this.unicodeReference = new StringBuilder(3);
                    this.unicodeReference.append(c);
                    return false;
                }
            }
            throw ASCIIPropertyListParser.this.createParseException("The property list contains an invalid escape sequence: \\" + c, this.startIndex);
        }

        private boolean handleNextCharOfHexEscapeSequence(char c) throws ParseException {
            if (Character.digit(c, 16) == -1) {
                String string = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
                throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an invalid escape sequence: " + string, this.startIndex);
            }
            this.unicodeReference.append(c);
            if (this.unicodeReference.length() == 4) {
                char c2 = (char)Integer.parseInt(this.unicodeReference.toString(), 16);
                this.stringBuilder.append(c2);
                return true;
            }
            return false;
        }

        private boolean handleNextCharOfOctalEscapeSequence(char c) throws ParseException {
            if (Character.digit(c, 8) == -1) {
                String string = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
                throw ASCIIPropertyListParser.this.createParseException("The property list contains a string with an invalid escape sequence: " + string, this.startIndex);
            }
            this.unicodeReference.append(c);
            if (this.unicodeReference.length() == 3) {
                char c2 = (char)Integer.parseInt(this.unicodeReference.toString(), 8);
                this.stringBuilder.append(c2);
                return true;
            }
            return false;
        }
    }
}

