/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.wrappers;

import java.io.Serializable;
import java.util.Date;
import org.quartz.Calendar;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.terracotta.quartz.wrappers.TriggerFacade;

public class TriggerWrapper
implements Serializable {
    private final boolean jobDisallowsConcurrence;
    private volatile String lastTerracotaClientId = null;
    private volatile TriggerState state = TriggerState.WAITING;
    protected final OperableTrigger trigger;

    protected TriggerWrapper(OperableTrigger operableTrigger, boolean bl) {
        this.trigger = operableTrigger;
        this.jobDisallowsConcurrence = bl;
    }

    public boolean jobDisallowsConcurrence() {
        return this.jobDisallowsConcurrence;
    }

    public String getLastTerracotaClientId() {
        return this.lastTerracotaClientId;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( " + (Object)((Object)this.state) + ", lastTC=" + this.lastTerracotaClientId + ", " + this.trigger + ")";
    }

    public TriggerKey getKey() {
        return this.trigger.getKey();
    }

    public JobKey getJobKey() {
        return this.trigger.getJobKey();
    }

    public void setState(TriggerState triggerState, String string, TriggerFacade triggerFacade) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.state = triggerState;
        this.lastTerracotaClientId = string;
        this.rePut(triggerFacade);
    }

    public TriggerState getState() {
        return this.state;
    }

    public Date getNextFireTime() {
        return this.trigger.getNextFireTime();
    }

    public int getPriority() {
        return this.trigger.getPriority();
    }

    public boolean mayFireAgain() {
        return this.trigger.mayFireAgain();
    }

    public OperableTrigger getTriggerClone() {
        return (OperableTrigger)this.trigger.clone();
    }

    public void updateWithNewCalendar(Calendar calendar, long l, TriggerFacade triggerFacade) {
        this.trigger.updateWithNewCalendar(calendar, l);
        this.rePut(triggerFacade);
    }

    public String getCalendarName() {
        return this.trigger.getCalendarName();
    }

    public int getMisfireInstruction() {
        return this.trigger.getMisfireInstruction();
    }

    public void updateAfterMisfire(Calendar calendar, TriggerFacade triggerFacade) {
        this.trigger.updateAfterMisfire(calendar);
        this.rePut(triggerFacade);
    }

    public void setFireInstanceId(String string, TriggerFacade triggerFacade) {
        this.trigger.setFireInstanceId(string);
        this.rePut(triggerFacade);
    }

    public void triggered(Calendar calendar, TriggerFacade triggerFacade) {
        this.trigger.triggered(calendar);
        this.rePut(triggerFacade);
    }

    private void rePut(TriggerFacade triggerFacade) {
        triggerFacade.put(this.trigger.getKey(), this);
    }

    public boolean isInstanceof(Class clazz) {
        return clazz.isInstance(this.trigger);
    }

    public static enum TriggerState {
        WAITING,
        ACQUIRED,
        COMPLETE,
        PAUSED,
        BLOCKED,
        PAUSED_BLOCKED,
        ERROR;

    }
}

