/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.collections;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.terracotta.quartz.collections.SerializationHelper;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;
import org.terracotta.toolkit.store.ToolkitStore;

public class SerializedToolkitStore<K, V extends Serializable>
implements ToolkitStore<K, V> {
    private final ToolkitStore<String, V> toolkitStore;

    public SerializedToolkitStore(ToolkitStore toolkitStore) {
        this.toolkitStore = toolkitStore;
    }

    public int size() {
        return this.toolkitStore.size();
    }

    public boolean isEmpty() {
        return this.toolkitStore.isEmpty();
    }

    private static String serializeToString(Object object) {
        try {
            return SerializationHelper.serializeToString(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static Object deserializeFromString(String string) {
        try {
            return SerializationHelper.deserializeFromString(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public boolean containsKey(Object object) {
        return this.toolkitStore.containsKey((Object)SerializedToolkitStore.serializeToString(object));
    }

    public V get(Object object) {
        return (V)((Serializable)this.toolkitStore.get((Object)SerializedToolkitStore.serializeToString(object)));
    }

    public V put(K k, V v) {
        return (V)((Serializable)this.toolkitStore.put((Object)SerializedToolkitStore.serializeToString(k), v));
    }

    public V remove(Object object) {
        return (V)((Serializable)this.toolkitStore.remove((Object)SerializedToolkitStore.serializeToString(object)));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        HashMap<String, V> hashMap = new HashMap<String, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            hashMap.put(SerializedToolkitStore.serializeToString(entry.getKey()), entry.getValue());
        }
        this.toolkitStore.putAll(hashMap);
    }

    public void clear() {
        this.toolkitStore.clear();
    }

    public Set<K> keySet() {
        return new ToolkitKeySet(this.toolkitStore.keySet());
    }

    public boolean isDestroyed() {
        return this.toolkitStore.isDestroyed();
    }

    public void destroy() {
        this.toolkitStore.destroy();
    }

    public String getName() {
        return this.toolkitStore.getName();
    }

    public ToolkitReadWriteLock createLockForKey(K k) {
        return this.toolkitStore.createLockForKey((Object)SerializedToolkitStore.serializeToString(k));
    }

    public void removeNoReturn(Object object) {
        this.toolkitStore.removeNoReturn((Object)SerializedToolkitStore.serializeToString(object));
    }

    public void putNoReturn(K k, V v) {
        this.toolkitStore.putNoReturn((Object)SerializedToolkitStore.serializeToString(k), v);
    }

    public Map<K, V> getAll(Collection<? extends K> collection) {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : collection) {
            hashSet.add(SerializedToolkitStore.serializeToString(object2));
        }
        Map map = this.toolkitStore.getAll(hashSet);
        object2 = map.isEmpty() ? Collections.EMPTY_MAP : new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            object2.put((Object)SerializedToolkitStore.deserializeFromString((String)entry.getKey()), entry.getValue());
        }
        return object2;
    }

    public Configuration getConfiguration() {
        return this.toolkitStore.getConfiguration();
    }

    public void setConfigField(String string, Serializable serializable) {
        this.toolkitStore.setConfigField(string, serializable);
    }

    public boolean containsValue(Object object) {
        return this.toolkitStore.containsValue(object);
    }

    public V putIfAbsent(K k, V v) {
        return (V)((Serializable)this.toolkitStore.putIfAbsent((Object)SerializedToolkitStore.serializeToString(k), v));
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new ToolkitEntrySet(this.toolkitStore.entrySet());
    }

    public Collection<V> values() {
        return this.toolkitStore.values();
    }

    public boolean remove(Object object, Object object2) {
        return this.toolkitStore.remove((Object)SerializedToolkitStore.serializeToString(object), object2);
    }

    public boolean replace(K k, V v, V v2) {
        return this.toolkitStore.replace((Object)SerializedToolkitStore.serializeToString(k), v, v2);
    }

    public V replace(K k, V v) {
        return (V)((Serializable)this.toolkitStore.replace((Object)SerializedToolkitStore.serializeToString(k), v));
    }

    public boolean isBulkLoadEnabled() {
        return this.toolkitStore.isBulkLoadEnabled();
    }

    public boolean isNodeBulkLoadEnabled() {
        return this.toolkitStore.isNodeBulkLoadEnabled();
    }

    public void setNodeBulkLoadEnabled(boolean bl) {
        this.toolkitStore.setNodeBulkLoadEnabled(bl);
    }

    public void waitUntilBulkLoadComplete() throws InterruptedException {
        this.toolkitStore.waitUntilBulkLoadComplete();
    }

    public void setAttributeExtractor(ToolkitAttributeExtractor toolkitAttributeExtractor) {
        this.toolkitStore.setAttributeExtractor(toolkitAttributeExtractor);
    }

    public QueryBuilder createQueryBuilder() {
        throw new UnsupportedOperationException();
    }

    private static class ToolkitKeyIterator<K>
    implements Iterator<K> {
        private final Iterator<String> iter;

        public ToolkitKeyIterator(Iterator<String> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public K next() {
            String string = this.iter.next();
            if (string == null) {
                return null;
            }
            return (K)SerializedToolkitStore.deserializeFromString(string);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static class ToolkitKeySet<K>
    implements Set<K> {
        private final Set<String> set;

        public ToolkitKeySet(Set<String> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.set.contains(SerializedToolkitStore.serializeToString(object));
        }

        @Override
        public Iterator<K> iterator() {
            return new ToolkitKeyIterator(this.set.iterator());
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ToolkitMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K k;
        private final V v;

        public ToolkitMapEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ToolkitEntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<String, V>> iter;

        public ToolkitEntryIterator(Iterator<Map.Entry<String, V>> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<String, V> entry = this.iter.next();
            if (entry == null) {
                return null;
            }
            return new ToolkitMapEntry<Object, V>(SerializedToolkitStore.deserializeFromString(entry.getKey()), entry.getValue());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static class ToolkitEntrySet<K, V>
    implements Set<Map.Entry<K, V>> {
        private final Set<Map.Entry<String, V>> set;

        public ToolkitEntrySet(Set<Map.Entry<String, V>> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            ToolkitMapEntry toolkitMapEntry = null;
            toolkitMapEntry = new ToolkitMapEntry(SerializedToolkitStore.serializeToString(entry.getKey()), entry.getValue());
            return this.set.contains(toolkitMapEntry);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ToolkitEntryIterator(this.set.iterator());
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

