/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.collections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SerializationHelper {
    private static final char MARKER = '\ufffe';

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("error serializing " + object, iOException);
        }
    }

    public static Object deserialize(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException("error deserializing " + byArray, exception);
        }
    }

    public static Object deserializeFromString(String string) throws IOException, ClassNotFoundException {
        if (string.length() >= 1 && string.charAt(0) == '\ufffe') {
            ObjectInputStream objectInputStream = new ObjectInputStream(new StringSerializedObjectInputStream(string));
            return objectInputStream.readObject();
        }
        return string;
    }

    public static String serializeToString(Object object) throws IOException {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() >= 1 && string.charAt(0) == '\ufffe') {
                throw new IOException("Illegal string key: " + string);
            }
            return string;
        }
        StringSerializedObjectOutputStream stringSerializedObjectOutputStream = new StringSerializedObjectOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(stringSerializedObjectOutputStream);
        SerializationHelper.writeStringKey(object, objectOutputStream);
        objectOutputStream.close();
        return stringSerializedObjectOutputStream.toString();
    }

    private static void writeStringKey(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(object);
    }

    private static class StringSerializedObjectInputStream
    extends InputStream {
        private final String source;
        private final int length;
        private int index;

        StringSerializedObjectInputStream(String string) {
            this.source = string;
            this.length = string.length();
            this.read();
        }

        @Override
        public int read() {
            if (this.index == this.length) {
                return -1;
            }
            return this.source.charAt(this.index++) & 0xFF;
        }
    }

    private static class StringSerializedObjectOutputStream
    extends OutputStream {
        private int count;
        private char[] buf;

        StringSerializedObjectOutputStream() {
            this(16);
        }

        StringSerializedObjectOutputStream(int n) {
            n = Math.max(1, n);
            this.buf = new char[n];
            this.buf[this.count++] = 65534;
        }

        @Override
        public void write(int n) {
            if (this.count + 1 > this.buf.length) {
                char[] cArray = new char[this.buf.length << 1];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            this.writeChar(n);
        }

        private void writeChar(int n) {
            this.buf[this.count++] = (char)(n & 0xFF);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                char[] cArray = new char[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            for (int i = 0; i < n2; ++i) {
                this.writeChar(byArray[n + i]);
            }
        }

        public String toString() {
            return new String(this.buf, 0, this.count);
        }
    }
}

