/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;

public class ReflectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> hashSet = Sets.newHashSet();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            hashSet.addAll(Sets.newHashSet(clazz2.getDeclaredFields()));
        }
        return hashSet;
    }

    public static Field getField(Class<?> clazz, String string) {
        return ReflectUtils.getField(clazz, string, clazz);
    }

    private static Field getField(Class<?> clazz, String string, Class<?> clazz2) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            if (logger.isTraceEnabled()) {
                logger.trace("found field " + string + " in " + ReflectUtils.getClassNameSafe(clazz));
            }
        }
        catch (SecurityException securityException) {
            throw new SquirrelRuntimeException(securityException, ErrorCodes.NOT_ALLOW_ACCESS_FIELD, ReflectUtils.getClassNameSafe(clazz), string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtils.getField(clazz.getSuperclass(), string, clazz2);
            }
            throw new SquirrelRuntimeException(noSuchFieldException, ErrorCodes.FIELD_NOT_FOUND, clazz2.getName(), string);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        return ReflectUtils.getMethod(clazz, string, classArray, clazz);
    }

    private static Method getMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
            if (logger.isTraceEnabled()) {
                logger.trace("found method " + ReflectUtils.getClassNameSafe(clazz) + "." + string + "(" + Arrays.toString(classArray) + ")");
            }
        }
        catch (SecurityException securityException) {
            throw new SquirrelRuntimeException(securityException, ErrorCodes.NOT_ALLOW_ACCESS_METHOD, ReflectUtils.getClassNameSafe(clazz), string, ReflectUtils.getParameterTypesText(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtils.getMethod(clazz.getSuperclass(), string, classArray, clazz2);
            }
            throw new SquirrelRuntimeException(noSuchMethodException, ErrorCodes.METHOD_NOT_FOUND, clazz2.getName(), string, ReflectUtils.getParameterTypesText(classArray));
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] classArray) {
        if (classArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            stringBuilder.append(clazz.getName());
            if (i == classArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String logMethod(Method method) {
        StringBuilder stringBuilder = new StringBuilder(method.getDeclaringClass().getSimpleName());
        stringBuilder.append('.').append(method.getName()).append('(');
        if (method.getParameterTypes() != null) {
            int n = method.getParameterTypes().length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(method.getParameterTypes()[i].getSimpleName());
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2) {
        T t = null;
        if (clazz.isAnnotationPresent(clazz2)) {
            t = clazz.getAnnotation(clazz2);
        } else {
            if (ReflectUtils.shouldInspectClass(clazz.getSuperclass())) {
                t = ReflectUtils.getAnnotation(clazz.getSuperclass(), clazz2);
            }
            if (t == null) {
                Class<?> clazz3;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (t = (T)ReflectUtils.getAnnotation(clazz3 = classArray[i], clazz2)) == null; ++i) {
                }
            }
        }
        return t;
    }

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return ReflectUtils.getAnnotation(clazz, clazz2) != null;
    }

    public static List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> clazz2) {
        ArrayList<Method> arrayList = Lists.newArrayList();
        for (Method genericDeclaration : clazz.getMethods()) {
            if (genericDeclaration.getAnnotation(clazz2) == null) continue;
            arrayList.add(genericDeclaration);
        }
        if (ReflectUtils.shouldInspectClass(clazz.getSuperclass())) {
            arrayList.addAll(ReflectUtils.getAnnotatedMethods(clazz.getSuperclass(), clazz2));
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            arrayList.addAll(ReflectUtils.getAnnotatedMethods(genericDeclaration, clazz2));
        }
        return arrayList;
    }

    private static boolean shouldInspectClass(Class<?> clazz) {
        return !Object.class.equals(clazz) && clazz != null;
    }

    public static Field[] getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> clazz2) {
        ArrayList<Field> arrayList = Lists.newArrayList();
        Class<?> clazz3 = clazz;
        while (ReflectUtils.shouldInspectClass(clazz3)) {
            for (Field field : clazz3.getFields()) {
                if (field.getAnnotation(clazz2) == null) continue;
                arrayList.add(field);
            }
            clazz3 = clazz3.getSuperclass();
        }
        return arrayList.toArray(new Field[0]);
    }

    public static boolean isAnnotatedWith(Object object, Class<? extends Annotation> clazz) {
        if (object instanceof Class) {
            return ReflectUtils.hasAnnotation((Class)object, clazz);
        }
        if (object instanceof Field) {
            return ((Field)object).getAnnotation(clazz) != null;
        }
        if (object instanceof Method) {
            return ((Method)object).getAnnotation(clazz) != null;
        }
        return false;
    }

    public static Method getFirstMethodOfName(Class<?> clazz, String string) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] classArray) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(classArray);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SquirrelRuntimeException(noSuchMethodException, ErrorCodes.CONSTRUCTOR_NOT_FOUND, clazz.getName(), Arrays.toString(classArray));
        }
    }

    public static <T> T newInstance(String string) {
        return (T)ReflectUtils.newInstance(ReflectUtils.getClass(string), null, null);
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectUtils.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ReflectUtils.newInstance(null, constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] objectArray) {
        return ReflectUtils.newInstance(null, constructor, objectArray);
    }

    private static <T> T newInstance(Class<T> clazz, Constructor<T> constructor, Object[] objectArray) {
        if (clazz == null && constructor == null) {
            throw new IllegalArgumentException("can't create new instance without clazz or constructor");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("creating new instance for class '" + ReflectUtils.getClassNameSafe(clazz) + "' with args " + Arrays.toString(objectArray));
        }
        if (constructor == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("getting default constructor");
            }
            constructor = ReflectUtils.getConstructor(clazz, null);
        }
        boolean bl = constructor.isAccessible();
        try {
            if (!constructor.isAccessible()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("making constructor accessible");
                }
                constructor.setAccessible(true);
            }
            T t = constructor.newInstance(objectArray);
            return t;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable instanceof InvocationTargetException ? ((InvocationTargetException)throwable).getTargetException() : throwable;
            throw new SquirrelRuntimeException(throwable2, ErrorCodes.CONSTRUCT_NEW_INSTANCE_ERROR, ReflectUtils.getClassNameSafe(clazz), Arrays.toString(objectArray));
        }
        finally {
            constructor.setAccessible(bl);
        }
    }

    public static Object getStatic(Field field) {
        return ReflectUtils.get(field, null);
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new SquirrelRuntimeException(ErrorCodes.FIELD_NULL);
        }
        boolean bl = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            if (logger.isTraceEnabled()) {
                logger.trace("got value '" + object2 + "' from field '" + field.getName() + "'");
            }
            Object object3 = object2;
            return object3;
        }
        catch (Exception exception) {
            throw new SquirrelRuntimeException(exception, ErrorCodes.CANNOT_GET_FIELD_VALUE, field.getName());
        }
        finally {
            field.setAccessible(bl);
        }
    }

    public static void setStatic(Field field, Object object) {
        ReflectUtils.set(field, null, object);
    }

    public static void set(Field field, Object object, Object object2) {
        if (field == null) {
            throw new SquirrelRuntimeException(ErrorCodes.FIELD_NULL);
        }
        boolean bl = field.isAccessible();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("setting field '" + field.getName() + "' to value '" + object2 + "'");
            }
            if (!bl) {
                if (logger.isTraceEnabled()) {
                    logger.trace("making field accessible");
                }
                field.setAccessible(true);
            }
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new SquirrelRuntimeException(exception, ErrorCodes.CANNOT_SET_FIELD_VALUE, field.getName(), object2);
        }
        finally {
            field.setAccessible(bl);
        }
    }

    public static Object invokeStatic(Method method) {
        return ReflectUtils.invoke(method, null, new Object[0]);
    }

    public static Object invokeStatic(Method method, Object[] objectArray) {
        return ReflectUtils.invoke(method, null, objectArray);
    }

    public static Object invoke(Method method, Object object) {
        return ReflectUtils.invoke(method, object, new Object[0]);
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) {
        if (method == null) {
            throw new SquirrelRuntimeException(ErrorCodes.METHOD_NULL);
        }
        boolean bl = method.isAccessible();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("invoking '" + method.getName() + "' on '" + object + "' with " + Arrays.toString(objectArray));
            }
            if (!method.isAccessible()) {
                logger.trace("making method accessible");
                method.setAccessible(true);
            }
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new SquirrelRuntimeException(throwable, ErrorCodes.METHOD_INVOKE_ERROR, method, Arrays.toString(objectArray), object, throwable.getCause());
        }
        catch (Exception exception) {
            throw new SquirrelRuntimeException(exception, ErrorCodes.METHOD_INVOKE_ERROR, method, Arrays.toString(objectArray), object, exception.getMessage());
        }
        finally {
            method.setAccessible(bl);
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fieldCallback) throws IllegalArgumentException {
        ReflectUtils.doWithFields(clazz, fieldCallback, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fieldCallback, FieldFilter fieldFilter) throws IllegalArgumentException {
        Class<?> clazz2 = clazz;
        do {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                if (fieldFilter != null && !fieldFilter.matches(field)) continue;
                fieldCallback.doWith(field);
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback methodCallback) throws IllegalArgumentException {
        ReflectUtils.doWithMethods(clazz, methodCallback, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback methodCallback, MethodFilter methodFilter) throws IllegalArgumentException {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (Method genericDeclaration : methodArray) {
            if (methodFilter != null && !methodFilter.matches(genericDeclaration)) continue;
            methodCallback.doWith(genericDeclaration);
        }
        if (clazz.getSuperclass() != null) {
            ReflectUtils.doWithMethods(clazz.getSuperclass(), methodCallback, methodFilter);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectUtils.doWithMethods(genericDeclaration, methodCallback, methodFilter);
            }
        }
    }

    public static Class<?>[] getSuperclasses(Class<?> clazz) {
        Object object;
        int n = 0;
        for (object = clazz.getSuperclass(); object != null; object = object.getSuperclass()) {
            ++n;
        }
        object = new Class[n];
        n = 0;
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            object[n] = clazz2;
            ++n;
        }
        return object;
    }

    public static boolean isUserDefinedMethod(Method method) {
        return method.getDeclaringClass() != Object.class;
    }

    public static boolean isBeanProperty(Method method) {
        String string = method.getName();
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        return string.startsWith("get") && !string.equals("getClass") ? clazz != null && classArray.length == 0 : (string.startsWith("is") ? clazz != null && classArray.length == 0 : string.startsWith("set") && classArray.length == 1);
    }

    public static String getPackageName(String string) {
        if (string == null || string.length() == 0) {
            throw new SquirrelRuntimeException(ErrorCodes.ILLEGAL_CLASS_NAME);
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static Class<?> getClass(String string) {
        if (string == null || string.length() == 0) {
            throw new SquirrelRuntimeException(ErrorCodes.ILLEGAL_CLASS_NAME);
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SquirrelRuntimeException(classNotFoundException, ErrorCodes.CLASS_NOT_FOUND, string);
        }
    }

    private static String getClassNameSafe(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getName();
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1);
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1);
    }
}

