/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import java.util.Map;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.builder.ExternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.InternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.LocalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

class TransitionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements ExternalTransitionBuilder<T, S, E, C>,
InternalTransitionBuilder<T, S, E, C>,
LocalTransitionBuilder<T, S, E, C>,
From<T, S, E, C>,
To<T, S, E, C>,
On<T, S, E, C>,
SquirrelComponent {
    private final Map<S, MutableState<T, S, E, C>> states;
    private MutableState<T, S, E, C> sourceState;
    private MutableState<T, S, E, C> targetState;
    private MutableTransition<T, S, E, C> transition;
    private final TransitionType transitionType;
    private final int priority;
    private final ExecutionContext executionContext;

    TransitionBuilderImpl(Map<S, MutableState<T, S, E, C>> map, TransitionType transitionType, int n, ExecutionContext executionContext) {
        this.states = map;
        this.transitionType = transitionType;
        this.priority = n;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        this.transition.addAction(action);
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> list) {
        this.transition.addActions(list);
    }

    @Override
    public void evalMvel(String string) {
        Action action = FSM.newMvelAction(string, this.executionContext);
        this.transition.addAction(action);
    }

    @Override
    public void callMethod(String string) {
        MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(string, this.executionContext);
        this.transition.addAction(methodCallActionProxyImpl);
    }

    @Override
    public On<T, S, E, C> on(E e) {
        this.transition = this.sourceState.addTransitionOn(e);
        this.transition.setTargetState(this.targetState);
        this.transition.setType(this.transitionType);
        this.transition.setPriority(this.priority);
        return this;
    }

    @Override
    public To<T, S, E, C> to(S s) {
        this.targetState = FSM.getState(this.states, s);
        return this;
    }

    @Override
    public To<T, S, E, C> toFinal(S s) {
        this.targetState = FSM.getState(this.states, s);
        if (!this.targetState.isFinalState()) {
            this.targetState.setFinal(true);
        }
        return this;
    }

    @Override
    public From<T, S, E, C> from(S s) {
        this.sourceState = FSM.getState(this.states, s);
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        this.transition.setCondition(condition);
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String string) {
        Condition condition = FSM.newMvelCondition(string, this.executionContext.getScriptManager());
        this.transition.setCondition(condition);
        return this;
    }

    @Override
    public To<T, S, E, C> within(S s) {
        this.targetState = FSM.getState(this.states, s);
        this.sourceState = this.targetState;
        return this;
    }
}

