/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.LinkedList;
import org.squirrelframework.foundation.fsm.DotVisitor;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.AbstractVisitor;

class DotVisitorImpl
extends AbstractVisitor
implements DotVisitor {
    protected final StringBuilder transBuf = new StringBuilder();

    DotVisitorImpl() {
    }

    @Override
    public void visitOnEntry(StateMachine<?, ?, ?, ?> stateMachine) {
        this.writeLine("digraph {\ncompound=true;");
        this.writeLine("subgraph cluster_StateMachine {\nlabel=\"" + stateMachine.getClass().getName() + "\";");
    }

    @Override
    public void visitOnExit(StateMachine<?, ?, ?, ?> stateMachine) {
        this.buffer.append((CharSequence)this.transBuf);
        this.writeLine("}}");
    }

    @Override
    public void visitOnEntry(ImmutableState<?, ?, ?, ?> immutableState) {
        String string = immutableState.getStateId().toString();
        if (immutableState.hasChildStates()) {
            this.writeLine("subgraph cluster_" + string + " {\nlabel=\"" + string + "\";");
            if (immutableState.getHistoryType() == HistoryType.DEEP) {
                this.writeLine(string + "History" + " [label=\"\"];");
            } else if (immutableState.getHistoryType() == HistoryType.SHALLOW) {
                this.writeLine(string + "History" + " [label=\"\"];");
            }
        } else {
            this.writeLine(string + " [label=\"" + string + "\"];");
        }
    }

    @Override
    public void visitOnExit(ImmutableState<?, ?, ?, ?> immutableState) {
        if (immutableState.hasChildStates()) {
            this.writeLine("}");
        }
    }

    @Override
    public void visitOnEntry(ImmutableTransition<?, ?, ?, ?> immutableTransition) {
        ImmutableState<?, ?, ?, ?> immutableState = immutableTransition.getSourceState();
        ImmutableState<?, ?, ?, ?> immutableState2 = immutableTransition.getTargetState();
        String string = immutableState.getStateId().toString();
        String string2 = immutableState2.getStateId().toString();
        boolean bl = immutableState.hasChildStates();
        boolean bl2 = immutableState2.hasChildStates();
        String string3 = bl ? "cluster_" + string : null;
        String string4 = bl2 ? "cluster_" + string2 : null;
        String string5 = bl ? this.getSimpleChildOf(immutableState).getStateId().toString() : string;
        String string6 = bl2 ? this.getSimpleChildOf(immutableState2).getStateId().toString() : string2;
        String string7 = immutableTransition.getEvent().toString();
        String string8 = string3 != null ? "ltail=\"" + string3 + "\"" : null;
        String string9 = string4 != null ? "lhead=\"" + string4 + "\"" : null;
        this.transBuf.append("\n" + string5 + " -> " + string6 + " [" + (string8 != null ? string8 + "," : "") + (string9 != null ? string9 + "," : "") + " label=\"" + string7 + "\"];");
    }

    public ImmutableState<?, ?, ?, ?> getSimpleChildOf(ImmutableState<?, ?, ?, ?> immutableState) {
        LinkedList linkedList = new LinkedList();
        linkedList.add(immutableState);
        while (!linkedList.isEmpty()) {
            ImmutableState immutableState2 = (ImmutableState)linkedList.poll();
            int n = immutableState2.getChildStates().size();
            for (int i = 0; i < n; ++i) {
                ImmutableState immutableState3 = immutableState2.getChildStates().get(i);
                if (!immutableState3.hasChildStates()) {
                    return immutableState3;
                }
                linkedList.add(immutableState3);
            }
        }
        return immutableState;
    }

    @Override
    public void visitOnExit(ImmutableTransition<?, ?, ?, ?> immutableTransition) {
    }

    @Override
    public void convertDotFile(String string) {
        this.saveFile(string + ".dot", this.buffer.toString());
    }
}

