/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.component.impl.AbstractSubject;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.exception.TransitionException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionExecutionService;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineContext;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.UncallableActionImpl;
import org.squirrelframework.foundation.util.Pair;

public abstract class AbstractExecutionService<T extends StateMachine<T, S, E, C>, S, E, C>
extends AbstractSubject
implements ActionExecutionService<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExecutionService.class);
    protected final LinkedList<Pair<String, List<ActionContext<T, S, E, C>>>> actionBuckets = new LinkedList();
    protected boolean dummyExecution = false;
    private int actionTotalSize = 0;

    @Override
    public void begin(String string) {
        ArrayList arrayList = new ArrayList();
        this.actionBuckets.add(new Pair(string, arrayList));
    }

    @Override
    public void defer(Action<T, S, E, C> action, S s, S s2, E e, C c, T t) {
        Preconditions.checkNotNull(action, "Action parameter cannot be null.");
        List<ActionContext<T, S, ActionContext<T, S, E, C>, C>> list = this.actionBuckets.peekLast().second();
        Preconditions.checkNotNull(list, "Action bucket currently is empty. Make sure execution service is began.");
        list.add(ActionContext.get(action, s, s2, e, c, t, ++this.actionTotalSize));
    }

    private void doExecute(String string, List<ActionContext<T, S, E, C>> list) {
        Object object;
        Object object2;
        Preconditions.checkNotNull(list, "Action bucket cannot be empty when executing.");
        HashMap<Object, Object> hashMap = Maps.newHashMap();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            object2 = list.get(i);
            if (((ActionContext)object2).action.weight() != Integer.MIN_VALUE) {
                Object object3;
                try {
                    this.fireEvent(BeforeExecActionEventImpl.get(((ActionContext)object2).position, this.actionTotalSize, object2));
                    if (this.dummyExecution) continue;
                    if (((ActionContext)object2).action.isAsync()) {
                        boolean bl = StateMachineContext.isTestEvent();
                        object3 = (StateMachine)StateMachineContext.currentInstance();
                        object = SquirrelConfiguration.getExecutor().submit(new Runnable((StateMachine)object3, bl, (ActionContext)object2){
                            final /* synthetic */ StateMachine val$instance;
                            final /* synthetic */ boolean val$isTestEvent;
                            final /* synthetic */ ActionContext val$actionContext;
                            {
                                this.val$instance = stateMachine;
                                this.val$isTestEvent = bl;
                                this.val$actionContext = actionContext;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                StateMachineContext.set(this.val$instance, this.val$isTestEvent);
                                try {
                                    this.val$actionContext.run();
                                }
                                finally {
                                    StateMachineContext.set(null);
                                }
                            }
                        });
                        hashMap.put(object2, object);
                        continue;
                    }
                    ((ActionContext)object2).run();
                    continue;
                }
                catch (Exception exception) {
                    logger.error("Error during transition", exception);
                    object3 = exception instanceof SquirrelRuntimeException ? ((SquirrelRuntimeException)exception).getTargetException() : exception;
                    object = new TransitionException((Throwable)object3, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{((ActionContext)object2).from, ((ActionContext)object2).to, ((ActionContext)object2).event, ((ActionContext)object2).context, ((ActionContext)object2).action.name(), exception.getMessage()});
                    this.fireEvent(new ExecActionExceptionEventImpl((TransitionException)object, i + 1, n, object2));
                    throw object;
                }
                finally {
                    this.fireEvent(AfterExecActionEventImpl.get(i + 1, n, object2));
                }
            }
            logger.info("Method call action \"" + ((ActionContext)object2).action.name() + "\" (" + (i + 1) + " of " + n + ") was ignored.");
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Future)entry.getValue();
            ActionContext actionContext = (ActionContext)entry.getKey();
            try {
                logger.debug("Waiting action '" + actionContext.action.toString() + "' to finish.");
                if (actionContext.action.timeout() >= 0L) {
                    object2.get(actionContext.action.timeout(), TimeUnit.MILLISECONDS);
                } else {
                    object2.get();
                }
                logger.debug("Action '" + actionContext.action.toString() + "' finished.");
            }
            catch (Exception exception) {
                object2.cancel(true);
                object = exception;
                if (exception instanceof ExecutionException) {
                    object = ((ExecutionException)exception).getCause();
                }
                TransitionException transitionException = new TransitionException((Throwable)object, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{actionContext.from, actionContext.to, actionContext.event, actionContext.context, actionContext.action.name(), exception.getMessage()});
                this.fireEvent(new ExecActionExceptionEventImpl(transitionException, actionContext.position, this.actionTotalSize, actionContext));
                throw transitionException;
            }
        }
    }

    private void executeActions() {
        Pair<String, List<ActionContext<T, S, E, C>>> pair = this.actionBuckets.poll();
        String string = pair.first();
        List<ActionContext<T, S, E, C>> list = pair.second();
        this.doExecute(string, list);
        logger.debug("Actions within '" + string + "' invoked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            while (this.actionBuckets.size() > 0) {
                this.executeActions();
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.actionBuckets.clear();
        this.actionTotalSize = 0;
    }

    @Override
    public void addExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> beforeExecActionListener) {
        this.addListener(ActionExecutionService.BeforeExecActionEvent.class, beforeExecActionListener, ActionExecutionService.BeforeExecActionListener.METHOD);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> beforeExecActionListener) {
        this.removeListener(ActionExecutionService.BeforeExecActionEvent.class, beforeExecActionListener);
    }

    @Override
    public void addExecActionListener(ActionExecutionService.AfterExecActionListener<T, S, E, C> afterExecActionListener) {
        this.addListener(ActionExecutionService.AfterExecActionListener.class, afterExecActionListener, ActionExecutionService.AfterExecActionListener.METHOD);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.AfterExecActionListener<T, S, E, C> afterExecActionListener) {
        this.removeListener(ActionExecutionService.AfterExecActionListener.class, afterExecActionListener);
    }

    @Override
    public void addExecActionExceptionListener(ActionExecutionService.ExecActionExceptionListener<T, S, E, C> execActionExceptionListener) {
        this.addListener(ActionExecutionService.ExecActionExceptionEvent.class, execActionExceptionListener, ActionExecutionService.ExecActionExceptionListener.METHOD);
    }

    @Override
    public void removeExecActionExceptionListener(ActionExecutionService.ExecActionExceptionListener<T, S, E, C> execActionExceptionListener) {
        this.removeListener(ActionExecutionService.ExecActionExceptionEvent.class, execActionExceptionListener);
    }

    @Override
    public void setDummyExecution(boolean bl) {
        this.dummyExecution = bl;
    }

    static class ActionContext<T extends StateMachine<T, S, E, C>, S, E, C> {
        final Action<T, S, E, C> action;
        final S from;
        final S to;
        final E event;
        final C context;
        final T fsm;
        final int position;

        private ActionContext(Action<T, S, E, C> action, S s, S s2, E e, C c, T t, int n) {
            this.action = action;
            this.from = s;
            this.to = s2;
            this.event = e;
            this.context = c;
            this.fsm = t;
            this.position = n;
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionContext<T, S, E, C> get(Action<T, S, E, C> action, S s, S s2, E e, C c, T t, int n) {
            return new ActionContext<T, S, E, C>(action, s, s2, e, c, t, n);
        }

        void run() {
            AbstractStateMachine abstractStateMachine = (AbstractStateMachine)this.fsm;
            abstractStateMachine.beforeActionInvoked(this.from, this.to, this.event, this.context);
            this.action.execute(this.from, this.to, this.event, this.context, this.fsm);
            abstractStateMachine.afterActionInvoked(this.from, this.to, this.event, this.context);
        }
    }

    static abstract class AbstractExecActionEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    implements ActionExecutionService.ActionEvent<T, S, E, C> {
        private ActionContext<T, S, E, C> executionContext;
        private int pos;
        private int size;

        AbstractExecActionEvent(int n, int n2, ActionContext<T, S, E, C> actionContext) {
            this.pos = n;
            this.size = n2;
            this.executionContext = actionContext;
        }

        @Override
        public Action<T, S, E, C> getExecutionTarget() {
            return new UncallableActionImpl(this.executionContext.action);
        }

        @Override
        public S getFrom() {
            return this.executionContext.from;
        }

        @Override
        public S getTo() {
            return this.executionContext.to;
        }

        @Override
        public E getEvent() {
            return this.executionContext.event;
        }

        @Override
        public C getContext() {
            return this.executionContext.context;
        }

        @Override
        public T getStateMachine() {
            return this.executionContext.fsm;
        }

        @Override
        public int[] getMOfN() {
            return new int[]{this.pos, this.size};
        }
    }

    static class AfterExecActionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.AfterExecActionEvent<T, S, E, C> {
        AfterExecActionEventImpl(int n, int n2, ActionContext<T, S, E, C> actionContext) {
            super(n, n2, actionContext);
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionExecutionService.AfterExecActionEvent<T, S, E, C> get(int n, int n2, ActionContext<T, S, E, C> actionContext) {
            return new AfterExecActionEventImpl<T, S, E, C>(n, n2, actionContext);
        }
    }

    static class BeforeExecActionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.BeforeExecActionEvent<T, S, E, C> {
        BeforeExecActionEventImpl(int n, int n2, ActionContext<T, S, E, C> actionContext) {
            super(n, n2, actionContext);
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionExecutionService.BeforeExecActionEvent<T, S, E, C> get(int n, int n2, ActionContext<T, S, E, C> actionContext) {
            return new BeforeExecActionEventImpl<T, S, E, C>(n, n2, actionContext);
        }
    }

    static class ExecActionExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.ExecActionExceptionEvent<T, S, E, C> {
        private final TransitionException e;

        ExecActionExceptionEventImpl(TransitionException transitionException, int n, int n2, ActionContext<T, S, E, C> actionContext) {
            super(n, n2, actionContext);
            this.e = transitionException;
        }

        @Override
        public TransitionException getException() {
            return this.e;
        }
    }
}

