/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelPostProcessorProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public class SquirrelProvider
implements SquirrelSingleton {
    private static SquirrelProvider instance = new SquirrelProvider();
    private Map<Class<?>, Class<?>> implementationRegistry = new ConcurrentHashMap();

    public static SquirrelProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelProvider squirrelProvider) {
        instance = squirrelProvider;
    }

    public <T> T newInstance(TypeReference<T> typeReference) {
        return this.newInstance(typeReference, null, null);
    }

    public <T> T newInstance(TypeReference<T> typeReference, Class<?>[] classArray, Object[] objectArray) {
        Class<T> clazz = typeReference.getRawType();
        return clazz.cast(this.newInstance(clazz, classArray, objectArray));
    }

    public <T> T newInstance(Class<T> clazz) {
        return this.newInstance(clazz, null, null);
    }

    public <T> T newInstance(Class<T> clazz, Class<?>[] classArray, Object[] objectArray) {
        Class<T> clazz2 = this.getImplementation(clazz);
        if (objectArray == null) {
            return this.postProcess(clazz, ReflectUtils.newInstance(clazz2));
        }
        Constructor<T> constructor = ReflectUtils.getConstructor(clazz2, classArray);
        return this.postProcess(clazz, ReflectUtils.newInstance(constructor, objectArray));
    }

    private <T> T postProcess(Class<T> clazz, T t) {
        SquirrelPostProcessor<T> squirrelPostProcessor = SquirrelPostProcessorProvider.getInstance().getPostProcessor(clazz);
        if (squirrelPostProcessor != null && t != null) {
            squirrelPostProcessor.postProcess(t);
        }
        return t;
    }

    public void register(Class<?> clazz, Class<?> clazz2) {
        this.implementationRegistry.put(clazz, clazz2);
    }

    public void unregister(Class<?> clazz) {
        this.implementationRegistry.remove(clazz);
    }

    public void clearRegistry() {
        this.implementationRegistry.clear();
    }

    public <T> Class<T> getImplementation(Class<T> clazz) {
        return this.resolveImplIfInterface(clazz, new HashSet());
    }

    private <T> Class<T> resolveImplIfInterface(Class<T> clazz, Set<Class<?>> set) {
        if (!set.add(clazz)) {
            throw new IllegalStateException("Registration cycles: " + set);
        }
        if (!clazz.isInterface()) {
            Class<T> clazz2 = this.fromRegistry(clazz);
            if (clazz2 != null && !clazz2.isInterface()) {
                clazz = clazz2;
            }
            return clazz;
        }
        Class<T> clazz3 = this.fromRegistry(clazz);
        if (clazz3 == null) {
            clazz3 = this.findImplementationClass(clazz);
            this.register(clazz, clazz3);
        }
        return this.resolveImplIfInterface(clazz3, set);
    }

    private <T> Class<T> fromRegistry(Class<T> clazz) {
        Class<?> clazz2 = this.implementationRegistry.get(clazz);
        return clazz2;
    }

    private <T> Class<T> findImplementationClass(Class<T> clazz) {
        Class<?> clazz2 = null;
        String string = clazz.getName() + "Impl";
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = ReflectUtils.getPackageName(clazz.getName()) + ".impl." + clazz.getSimpleName() + "Impl";
            clazz2 = ReflectUtils.getClass(string);
        }
        return clazz2;
    }
}

