/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DirtyFlagMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1433884852607126222L;
    private boolean dirty = false;
    private Map<K, V> map;

    public DirtyFlagMap() {
        this.map = new HashMap();
    }

    public DirtyFlagMap(int n) {
        this.map = new HashMap(n);
    }

    public DirtyFlagMap(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Map<K, V> getWrappedMap() {
        return this.map;
    }

    @Override
    public void clear() {
        if (!this.map.isEmpty()) {
            this.dirty = true;
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new DirtyFlagMapEntrySet(this.map.entrySet());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DirtyFlagMap)) {
            return false;
        }
        return ((Object)this.map).equals(((DirtyFlagMap)object).getWrappedMap());
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new DirtyFlagSet<K>(this.map.keySet());
    }

    @Override
    public V put(K k, V v) {
        this.dirty = true;
        return this.map.put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.dirty = true;
        }
        this.map.putAll(map);
    }

    @Override
    public V remove(Object object) {
        V v = this.map.remove(object);
        if (v != null) {
            this.dirty = true;
        }
        return v;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return new DirtyFlagCollection<V>(this.map.values());
    }

    public Object clone() {
        DirtyFlagMap dirtyFlagMap;
        try {
            dirtyFlagMap = (DirtyFlagMap)super.clone();
            if (this.map instanceof HashMap) {
                dirtyFlagMap.map = (Map)((HashMap)this.map).clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return dirtyFlagMap;
    }

    private class DirtyFlagMapEntry
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> entry;

        public DirtyFlagMapEntry(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public V setValue(V v) {
            DirtyFlagMap.this.dirty = true;
            return this.entry.setValue(v);
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.entry).equals(object);
        }
    }

    private class DirtyFlagMapEntryIterator
    extends DirtyFlagIterator<Map.Entry<K, V>> {
        public DirtyFlagMapEntryIterator(Iterator<Map.Entry<K, V>> iterator) {
            super(iterator);
        }

        @Override
        public DirtyFlagMapEntry next() {
            return new DirtyFlagMapEntry((Map.Entry)super.next());
        }
    }

    private class DirtyFlagMapEntrySet
    extends DirtyFlagSet<Map.Entry<K, V>> {
        public DirtyFlagMapEntrySet(Set<Map.Entry<K, V>> set) {
            super(set);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new DirtyFlagMapEntryIterator(this.getWrappedSet().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.toArray((U[])new Object[super.size()]);
        }

        @Override
        public <U> U[] toArray(U[] UArray) {
            if (!UArray.getClass().getComponentType().isAssignableFrom(Map.Entry.class)) {
                throw new IllegalArgumentException("Array must be of type assignable from Map.Entry");
            }
            int n = super.size();
            U[] UArray2 = UArray.length < n ? (Object[])Array.newInstance(UArray.getClass().getComponentType(), n) : UArray;
            Iterator iterator = this.iterator();
            for (int i = 0; i < n; ++i) {
                UArray2[i] = iterator.next();
            }
            if (UArray2.length > n) {
                UArray2[n] = null;
            }
            return UArray2;
        }
    }

    private class DirtyFlagIterator<T>
    implements Iterator<T> {
        private Iterator<T> iterator;

        public DirtyFlagIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            DirtyFlagMap.this.dirty = true;
            this.iterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }
    }

    private class DirtyFlagSet<T>
    extends DirtyFlagCollection<T>
    implements Set<T> {
        public DirtyFlagSet(Set<T> set) {
            super(set);
        }

        protected Set<T> getWrappedSet() {
            return (Set)this.getWrappedCollection();
        }
    }

    private class DirtyFlagCollection<T>
    implements Collection<T> {
        private Collection<T> collection;

        public DirtyFlagCollection(Collection<T> collection) {
            this.collection = collection;
        }

        protected Collection<T> getWrappedCollection() {
            return this.collection;
        }

        @Override
        public Iterator<T> iterator() {
            return new DirtyFlagIterator<T>(this.collection.iterator());
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.collection.remove(object);
            if (bl) {
                DirtyFlagMap.this.dirty = true;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = this.collection.removeAll(collection);
            if (bl) {
                DirtyFlagMap.this.dirty = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = this.collection.retainAll(collection);
            if (bl) {
                DirtyFlagMap.this.dirty = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            if (!this.collection.isEmpty()) {
                DirtyFlagMap.this.dirty = true;
            }
            this.collection.clear();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        @Override
        public boolean add(T t) {
            return this.collection.add(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            return this.collection.addAll(collection);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.collection.containsAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <U> U[] toArray(U[] UArray) {
            return this.collection.toArray(UArray);
        }
    }
}

