/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.transaction.UserTransaction;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.jobs.FileScanJob;
import org.quartz.jobs.FileScanListener;
import org.quartz.plugins.SchedulerPluginWithUserTransactionSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.xml.XMLSchedulingDataProcessor;

public class XMLSchedulingDataProcessorPlugin
extends SchedulerPluginWithUserTransactionSupport
implements FileScanListener {
    private static final int MAX_JOB_TRIGGER_NAME_LEN = 80;
    private static final String JOB_INITIALIZATION_PLUGIN_NAME = "JobSchedulingDataLoaderPlugin";
    private static final String FILE_NAME_DELIMITERS = ",";
    private boolean failOnFileNotFound = true;
    private String fileNames = "quartz_data.xml";
    private Map<String, JobFile> jobFiles = new LinkedHashMap<String, JobFile>();
    private long scanInterval = 0L;
    boolean started = false;
    protected ClassLoadHelper classLoadHelper = null;
    private Set<String> jobTriggerNameSet = new HashSet<String>();

    public String getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String string) {
        this.fileNames = string;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long l) {
        this.scanInterval = l * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean bl) {
        this.failOnFileNotFound = bl;
    }

    @Override
    public void initialize(String string, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        super.initialize(string, scheduler);
        this.classLoadHelper = classLoadHelper;
        this.getLog().info("Registering Quartz Job Initialization Plug-in.");
        StringTokenizer stringTokenizer = new StringTokenizer(this.fileNames, FILE_NAME_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JobFile jobFile = new JobFile(string2);
            this.jobFiles.put(string2, jobFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(UserTransaction userTransaction) {
        try {
            if (!this.jobFiles.isEmpty()) {
                if (this.scanInterval > 0L) {
                    this.getScheduler().getContext().put("JobSchedulingDataLoaderPlugin_" + this.getName(), (Object)this);
                }
                for (JobFile jobFile : this.jobFiles.values()) {
                    if (this.scanInterval > 0L) {
                        String string = this.buildJobTriggerName(jobFile.getFileBasename());
                        TriggerKey triggerKey = new TriggerKey(string, JOB_INITIALIZATION_PLUGIN_NAME);
                        this.getScheduler().unscheduleJob(triggerKey);
                        JobDetail jobDetail = JobBuilder.newJob().withIdentity(string, JOB_INITIALIZATION_PLUGIN_NAME).ofType(FileScanJob.class).usingJobData("FILE_NAME", jobFile.getFileName()).usingJobData("FILE_SCAN_LISTENER_NAME", "JobSchedulingDataLoaderPlugin_" + this.getName()).build();
                        SimpleTrigger simpleTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule(SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(this.scanInterval)).forJob(jobDetail).build();
                        this.getScheduler().scheduleJob(jobDetail, simpleTrigger);
                        this.getLog().debug("Scheduled file scan job for data file: {}, at interval: {}", (Object)jobFile.getFileName(), (Object)this.scanInterval);
                    }
                    this.processFile(jobFile);
                }
            }
        }
        catch (SchedulerException schedulerException) {
            this.getLog().error("Error starting background-task for watching jobs file.", schedulerException);
        }
        finally {
            this.started = true;
        }
    }

    private String buildJobTriggerName(String string) {
        String string2 = "JobSchedulingDataLoaderPlugin_" + this.getName() + '_' + string.replace('.', '_');
        if (string2.length() > 80) {
            string2 = string2.substring(0, 80);
        }
        int n = 1;
        while (!this.jobTriggerNameSet.add(string2)) {
            if (n > 1) {
                string2 = string2.substring(0, string2.lastIndexOf(95));
            }
            String string3 = "_" + n++;
            if (string2.length() > 80 - string3.length()) {
                string2 = string2.substring(0, 80 - string3.length());
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    @Override
    public void shutdown() {
    }

    private void processFile(JobFile jobFile) {
        if (jobFile == null || !jobFile.getFileFound()) {
            return;
        }
        try {
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor = new XMLSchedulingDataProcessor(this.classLoadHelper);
            xMLSchedulingDataProcessor.addJobGroupToNeverDelete(JOB_INITIALIZATION_PLUGIN_NAME);
            xMLSchedulingDataProcessor.addTriggerGroupToNeverDelete(JOB_INITIALIZATION_PLUGIN_NAME);
            xMLSchedulingDataProcessor.processFileAndScheduleJobs(jobFile.getFileName(), jobFile.getFileName(), this.getScheduler());
        }
        catch (Exception exception) {
            this.getLog().error("Error scheduling jobs: " + exception.getMessage(), exception);
        }
    }

    public void processFile(String string) {
        this.processFile(this.jobFiles.get(string));
    }

    @Override
    public void fileUpdated(String string) {
        if (this.started) {
            this.processFile(string);
        }
    }

    class JobFile {
        private String fileName;
        private String filePath;
        private String fileBasename;
        private boolean fileFound;

        protected JobFile(String string) throws SchedulerException {
            this.fileName = string;
            this.initialize();
        }

        protected String getFileName() {
            return this.fileName;
        }

        protected boolean getFileFound() {
            return this.fileFound;
        }

        protected String getFilePath() {
            return this.filePath;
        }

        protected String getFileBasename() {
            return this.fileBasename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() throws SchedulerException {
            InputStream inputStream = null;
            try {
                String string = null;
                File file = new File(this.getFileName());
                if (!file.exists()) {
                    URL uRL = XMLSchedulingDataProcessorPlugin.this.classLoadHelper.getResource(this.getFileName());
                    if (uRL != null) {
                        try {
                            string = URLDecoder.decode(uRL.getPath(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string = uRL.getPath();
                        }
                        file = new File(string);
                        try {
                            inputStream = uRL.openStream();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        inputStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (inputStream == null) {
                    if (XMLSchedulingDataProcessorPlugin.this.isFailOnFileNotFound()) {
                        throw new SchedulerException("File named '" + this.getFileName() + "' does not exist.");
                    }
                    XMLSchedulingDataProcessorPlugin.this.getLog().warn("File named '" + this.getFileName() + "' does not exist.");
                } else {
                    this.fileFound = true;
                }
                this.filePath = string != null ? string : file.getAbsolutePath();
                this.fileBasename = file.getName();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    XMLSchedulingDataProcessorPlugin.this.getLog().warn("Error closing jobs file " + this.getFileName(), iOException);
                }
            }
        }
    }
}

