/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendDestinationMessageJob
implements Job {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        try {
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            InitialContext initialContext = JmsHelper.getInitialContext(jobDataMap);
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(jobDataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(jobDataMap)) {
                connection = connectionFactory.createConnection();
            } else {
                String string = jobDataMap.getString("jms.user");
                String string2 = jobDataMap.getString("jms.password");
                connection = connectionFactory.createConnection(string, string2);
            }
            boolean bl = JmsHelper.useTransaction(jobDataMap);
            int n = jobDataMap.getInt("jms.acknowledge");
            session = connection.createSession(bl, n);
            Destination destination = (Destination)initialContext.lookup(jobDataMap.getString("jms.destination"));
            messageProducer = session.createProducer(destination);
            JmsMessageFactory jmsMessageFactory = JmsHelper.getMessageFactory(jobDataMap.getString("jms.message.factory.class.name"));
            Message message = jmsMessageFactory.createMessage(jobDataMap, session);
            messageProducer.send(message);
        }
        catch (Exception exception) {
            try {
                throw new JobExecutionException(exception);
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(messageProducer);
                JmsHelper.closeResource(session);
                JmsHelper.closeResource(connection);
                throw throwable;
            }
        }
        JmsHelper.closeResource(messageProducer);
        JmsHelper.closeResource(session);
        JmsHelper.closeResource(connection);
    }
}

