/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EJBInvokerJob
implements Job {
    public static final String EJB_JNDI_NAME_KEY = "ejb";
    public static final String EJB_METHOD_KEY = "method";
    public static final String EJB_ARG_TYPES_KEY = "argTypes";
    public static final String EJB_ARGS_KEY = "args";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String CREDENTIALS = "java.naming.security.credentials";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        String string = jobDataMap.getString(EJB_JNDI_NAME_KEY);
        String string2 = jobDataMap.getString(EJB_METHOD_KEY);
        Object[] objectArray = (Object[])jobDataMap.get(EJB_ARGS_KEY);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (string == null) {
            throw new JobExecutionException();
        }
        InitialContext initialContext = null;
        try {
            initialContext = this.getInitialContext(jobDataMap);
        }
        catch (NamingException namingException) {
            throw new JobExecutionException(namingException);
        }
        try {
            Object object;
            Object object2 = null;
            try {
                object2 = initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                throw new JobExecutionException(namingException);
            }
            EJBHome eJBHome = (EJBHome)PortableRemoteObject.narrow((Object)object2, EJBHome.class);
            EJBMetaData eJBMetaData = null;
            try {
                eJBMetaData = eJBHome.getEJBMetaData();
            }
            catch (RemoteException remoteException) {
                throw new JobExecutionException(remoteException);
            }
            Class clazz = eJBMetaData.getHomeInterfaceClass();
            Class clazz2 = eJBMetaData.getRemoteInterfaceClass();
            eJBHome = (EJBHome)PortableRemoteObject.narrow((Object)eJBHome, (Class)clazz);
            Method method = null;
            try {
                method = clazz.getMethod("create", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JobExecutionException(noSuchMethodException);
            }
            EJBObject eJBObject = null;
            try {
                eJBObject = (EJBObject)method.invoke((Object)eJBHome, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JobExecutionException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JobExecutionException(invocationTargetException);
            }
            Method method2 = null;
            try {
                object = (Class[])jobDataMap.get(EJB_ARG_TYPES_KEY);
                if (object == null) {
                    object = new Class[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        object[i] = objectArray[i].getClass();
                    }
                }
                method2 = clazz2.getMethod(string2, (Class<?>)object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JobExecutionException(noSuchMethodException);
            }
            try {
                object = method2.invoke((Object)eJBObject, objectArray);
                jobExecutionContext.setResult(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JobExecutionException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JobExecutionException(invocationTargetException);
            }
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    protected InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException {
        String string;
        String string2;
        String string3;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
        String string4 = jobDataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (string4 != null) {
            hashtable.put(INITIAL_CONTEXT_FACTORY, string4);
        }
        if ((string3 = jobDataMap.getString(PROVIDER_URL)) != null) {
            hashtable.put(PROVIDER_URL, string3);
        }
        if ((string2 = jobDataMap.getString(PRINCIPAL)) != null) {
            hashtable.put(PRINCIPAL, string2);
        }
        if ((string = jobDataMap.getString(CREDENTIALS)) != null) {
            hashtable.put(CREDENTIALS, string);
        }
        return hashtable.size() == 0 ? new InitialContext() : new InitialContext(hashtable);
    }
}

