/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.matchers;

import org.quartz.Matcher;
import org.quartz.utils.Key;

public abstract class StringMatcher<T extends Key<?>>
implements Matcher<T> {
    private static final long serialVersionUID = -2757924162611145836L;
    protected String compareTo;
    protected StringOperatorName compareWith;

    protected StringMatcher(String string, StringOperatorName stringOperatorName) {
        if (string == null) {
            throw new IllegalArgumentException("CompareTo value cannot be null!");
        }
        if (stringOperatorName == null) {
            throw new IllegalArgumentException("CompareWith operator cannot be null!");
        }
        this.compareTo = string;
        this.compareWith = stringOperatorName;
    }

    protected abstract String getValue(T var1);

    @Override
    public boolean isMatch(T t) {
        return this.compareWith.evaluate(this.getValue(t), this.compareTo);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.compareTo == null ? 0 : this.compareTo.hashCode());
        n2 = 31 * n2 + (this.compareWith == null ? 0 : this.compareWith.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StringMatcher stringMatcher = (StringMatcher)object;
        if (this.compareTo == null ? stringMatcher.compareTo != null : !this.compareTo.equals(stringMatcher.compareTo)) {
            return false;
        }
        return !(this.compareWith == null ? stringMatcher.compareWith != null : !this.compareWith.equals((Object)stringMatcher.compareWith));
    }

    public String getCompareToValue() {
        return this.compareTo;
    }

    public StringOperatorName getCompareWithOperator() {
        return this.compareWith;
    }

    public static enum StringOperatorName {
        EQUALS{

            @Override
            public boolean evaluate(String string, String string2) {
                return string.equals(string2);
            }
        }
        ,
        STARTS_WITH{

            @Override
            public boolean evaluate(String string, String string2) {
                return string.startsWith(string2);
            }
        }
        ,
        ENDS_WITH{

            @Override
            public boolean evaluate(String string, String string2) {
                return string.endsWith(string2);
            }
        }
        ,
        CONTAINS{

            @Override
            public boolean evaluate(String string, String string2) {
                return string.contains(string2);
            }
        }
        ,
        ANYTHING{

            @Override
            public boolean evaluate(String string, String string2) {
                return true;
            }
        };


        public abstract boolean evaluate(String var1, String var2);
    }
}

