/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.jdbcjobstore.CalendarIntervalTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.CronTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.DailyTimeIntervalTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.SimpleTriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.TriggerStatus;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;

public class StdJDBCDelegate
implements DriverDelegate,
StdJDBCConstants {
    protected Logger logger = null;
    protected String tablePrefix = "QRTZ_";
    protected String instanceId;
    protected String schedName;
    protected boolean useProperties;
    protected ClassLoadHelper classLoadHelper;
    protected List<TriggerPersistenceDelegate> triggerPersistenceDelegates = new LinkedList<TriggerPersistenceDelegate>();
    private String schedNameLiteral = null;

    @Override
    public void initialize(Logger logger, String string, String string2, String string3, ClassLoadHelper classLoadHelper, boolean bl, String string4) throws NoSuchDelegateException {
        String[] stringArray;
        this.logger = logger;
        this.tablePrefix = string;
        this.schedName = string2;
        this.instanceId = string3;
        this.useProperties = bl;
        this.classLoadHelper = classLoadHelper;
        this.addDefaultTriggerPersistenceDelegates();
        if (string4 == null) {
            return;
        }
        for (String string5 : stringArray = string4.split("\\|")) {
            String[] stringArray2 = string5.split("=");
            String string6 = stringArray2[0];
            if (stringArray2.length == 1 || stringArray2[1] == null || stringArray2[1].equals("")) continue;
            if (string6.equals("triggerPersistenceDelegateClasses")) {
                String[] stringArray3;
                for (String string7 : stringArray3 = stringArray2[1].split(",")) {
                    try {
                        Class<?> clazz = classLoadHelper.loadClass(string7);
                        this.addTriggerPersistenceDelegate((TriggerPersistenceDelegate)clazz.newInstance());
                    }
                    catch (Exception exception) {
                        throw new NoSuchDelegateException("Error instantiating TriggerPersistenceDelegate of type: " + string7, exception);
                    }
                }
                continue;
            }
            throw new NoSuchDelegateException("Unknown setting: '" + string6 + "'");
        }
    }

    protected void addDefaultTriggerPersistenceDelegates() {
        this.addTriggerPersistenceDelegate(new SimpleTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new CronTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new CalendarIntervalTriggerPersistenceDelegate());
        this.addTriggerPersistenceDelegate(new DailyTimeIntervalTriggerPersistenceDelegate());
    }

    protected boolean canUseProperties() {
        return this.useProperties;
    }

    public void addTriggerPersistenceDelegate(TriggerPersistenceDelegate triggerPersistenceDelegate) {
        this.logger.debug("Adding TriggerPersistenceDelegate of type: " + triggerPersistenceDelegate.getClass().getCanonicalName());
        triggerPersistenceDelegate.initialize(this.tablePrefix, this.schedName);
        this.triggerPersistenceDelegates.add(triggerPersistenceDelegate);
    }

    public TriggerPersistenceDelegate findTriggerPersistenceDelegate(OperableTrigger operableTrigger) {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (!triggerPersistenceDelegate.canHandleTriggerType(operableTrigger)) continue;
            return triggerPersistenceDelegate;
        }
        return null;
    }

    public TriggerPersistenceDelegate findTriggerPersistenceDelegate(String string) {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (!triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator().equals(string)) continue;
            return triggerPersistenceDelegate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerStatesFromOtherStates(Connection connection, String string, String string2, String string3) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectMisfiredTriggers(Connection connection, long l) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            resultSet = preparedStatement.executeQuery();
            LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_NAME");
                String string = resultSet.getString("TRIGGER_GROUP");
                linkedList.add(TriggerKey.triggerKey((String)object, string));
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectTriggersInState(Connection connection, String string) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            LinkedList<TriggerKey> linkedList2 = new LinkedList<TriggerKey>();
            while (resultSet.next()) {
                linkedList2.add(TriggerKey.triggerKey(resultSet.getString(1), resultSet.getString(2)));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectMisfiredTriggersInState(Connection connection, String string, long l) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_NAME");
                String string2 = resultSet.getString("TRIGGER_GROUP");
                linkedList.add(TriggerKey.triggerKey((String)object, string2));
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMisfiredTriggersInState(Connection connection, String string, long l, int n, List<TriggerKey> list) throws SQLException {
        boolean bl;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            boolean bl2 = false;
            while (resultSet.next() && !bl2) {
                if (list.size() == n) {
                    bl2 = true;
                    continue;
                }
                String string2 = resultSet.getString("TRIGGER_NAME");
                String string3 = resultSet.getString("TRIGGER_GROUP");
                list.add(TriggerKey.triggerKey(string2, string3));
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    @Override
    public int countMisfiredTriggersInState(Connection connection, String string, long l) throws SQLException {
        block3: {
            int n;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ?"));
                preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
                preparedStatement.setString(2, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return n;
        }
        throw new SQLException("No misfired trigger count returned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectMisfiredTriggersInGroupInState(Connection connection, String string, String string2, long l) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ? ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            preparedStatement.setBigDecimal(1, new BigDecimal(String.valueOf(l)));
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            resultSet = preparedStatement.executeQuery();
            LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_NAME");
                linkedList.add(TriggerKey.triggerKey((String)object, string));
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> selectTriggersForRecoveringJobs(Connection connection) throws SQLException, IOException, ClassNotFoundException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
            preparedStatement.setString(1, this.instanceId);
            this.setBoolean(preparedStatement, 2, true);
            resultSet = preparedStatement.executeQuery();
            long l = System.currentTimeMillis();
            LinkedList<SimpleTriggerImpl> linkedList = new LinkedList<SimpleTriggerImpl>();
            while (resultSet.next()) {
                object = resultSet.getString("JOB_NAME");
                String string = resultSet.getString("JOB_GROUP");
                String string2 = resultSet.getString("TRIGGER_NAME");
                String string3 = resultSet.getString("TRIGGER_GROUP");
                long l2 = resultSet.getLong("FIRED_TIME");
                long l3 = resultSet.getLong("SCHED_TIME");
                int n = resultSet.getInt("PRIORITY");
                SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl("recover_" + this.instanceId + "_" + String.valueOf(l++), "RECOVERING_JOBS", new Date(l3));
                simpleTriggerImpl.setJobName((String)object);
                simpleTriggerImpl.setJobGroup(string);
                simpleTriggerImpl.setPriority(n);
                simpleTriggerImpl.setMisfireInstruction(-1);
                JobDataMap jobDataMap = this.selectTriggerJobDataMap(connection, string2, string3);
                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", string2);
                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", string3);
                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(l2));
                jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(l3));
                simpleTriggerImpl.setJobDataMap(jobDataMap);
                linkedList.add(simpleTriggerImpl);
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteFiredTriggers(Connection connection) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1}"));
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteFiredTriggers(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SIMPLE_TRIGGERS  WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SIMPROP_TRIGGERS  WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertJobDetail(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            preparedStatement.setString(1, jobDetail.getKey().getName());
            preparedStatement.setString(2, jobDetail.getKey().getGroup());
            preparedStatement.setString(3, jobDetail.getDescription());
            preparedStatement.setString(4, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 5, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 6, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 7, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 8, jobDetail.requestsRecovery());
            this.setBytes(preparedStatement, 9, byteArrayOutputStream);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobDetail(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_NONCONCURRENT = ?, IS_UPDATE_DATA = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobDetail.getDescription());
            preparedStatement.setString(2, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 3, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 4, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 5, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 6, jobDetail.requestsRecovery());
            this.setBytes(preparedStatement, 7, byteArrayOutputStream);
            preparedStatement.setString(8, jobDetail.getKey().getName());
            preparedStatement.setString(9, jobDetail.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectTriggerKeysForJob(Connection connection, JobKey jobKey) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            LinkedList<TriggerKey> linkedList = new LinkedList<TriggerKey>();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_NAME");
                String string = resultSet.getString("TRIGGER_GROUP");
                linkedList.add(TriggerKey.triggerKey((String)object, string));
            }
            object = linkedList;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteJobDetail(Connection connection, JobKey jobKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Deleting job: " + jobKey);
            }
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isJobNonConcurrent(Connection connection, JobKey jobKey) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT IS_NONCONCURRENT FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = this.getBoolean(resultSet, "IS_NONCONCURRENT");
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean jobExists(Connection connection, JobKey jobKey) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = false;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobData(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            this.setBytes(preparedStatement, 1, byteArrayOutputStream);
            preparedStatement.setString(2, jobDetail.getKey().getName());
            preparedStatement.setString(3, jobDetail.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobDetail selectJobDetail(Connection connection, JobKey jobKey, ClassLoadHelper classLoadHelper) throws ClassNotFoundException, IOException, SQLException {
        Map<Object, Object> map;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            JobDetailImpl jobDetailImpl = null;
            if (resultSet.next()) {
                jobDetailImpl = new JobDetailImpl();
                jobDetailImpl.setName(resultSet.getString("JOB_NAME"));
                jobDetailImpl.setGroup(resultSet.getString("JOB_GROUP"));
                jobDetailImpl.setDescription(resultSet.getString("DESCRIPTION"));
                jobDetailImpl.setJobClass(classLoadHelper.loadClass(resultSet.getString("JOB_CLASS_NAME"), Job.class));
                jobDetailImpl.setDurability(this.getBoolean(resultSet, "IS_DURABLE"));
                jobDetailImpl.setRequestsRecovery(this.getBoolean(resultSet, "REQUESTS_RECOVERY"));
                map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                if (null != map) {
                    jobDetailImpl.setJobDataMap(new JobDataMap(map));
                }
            }
            map = jobDetailImpl;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<?, ?> getMapFromProperties(ResultSet resultSet) throws ClassNotFoundException, IOException, SQLException {
        InputStream inputStream = (InputStream)this.getJobDataFromBlob(resultSet, "JOB_DATA");
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        Map<?, ?> map = this.convertFromProperty(properties);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNumJobs(Connection connection) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> selectJobGroups(Connection connection) throws SQLException {
        LinkedList<String> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            while (resultSet.next()) {
                linkedList2.add(resultSet.getString(1));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JobKey> selectJobsInGroup(Connection connection, GroupMatcher<JobKey> groupMatcher) throws SQLException {
        HashSet<JobKey> hashSet;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this.isMatcherEquals(groupMatcher)) {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_GROUP = ?"));
                preparedStatement.setString(1, this.toSqlEqualsClause(groupMatcher));
            } else {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_GROUP LIKE ?"));
                preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            }
            resultSet = preparedStatement.executeQuery();
            LinkedList<JobKey> linkedList = new LinkedList<JobKey>();
            while (resultSet.next()) {
                linkedList.add(JobKey.jobKey(resultSet.getString(1), resultSet.getString(2)));
            }
            hashSet = new HashSet<JobKey>(linkedList);
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return hashSet;
    }

    protected boolean isMatcherEquals(GroupMatcher<?> groupMatcher) {
        return groupMatcher.getCompareWithOperator().equals((Object)StringMatcher.StringOperatorName.EQUALS);
    }

    protected String toSqlEqualsClause(GroupMatcher<?> groupMatcher) {
        return groupMatcher.getCompareToValue();
    }

    protected String toSqlLikeClause(GroupMatcher<?> groupMatcher) {
        String string;
        switch (groupMatcher.getCompareWithOperator()) {
            case EQUALS: {
                string = groupMatcher.getCompareToValue();
                break;
            }
            case CONTAINS: {
                string = "%" + groupMatcher.getCompareToValue() + "%";
                break;
            }
            case ENDS_WITH: {
                string = "%" + groupMatcher.getCompareToValue();
                break;
            }
            case STARTS_WITH: {
                string = groupMatcher.getCompareToValue() + "%";
                break;
            }
            case ANYTHING: {
                string = "%";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Don't know how to translate " + (Object)((Object)groupMatcher.getCompareWithOperator()) + " into SQL");
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement;
        block9: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (operableTrigger.getJobDataMap().size() > 0) {
                byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            }
            preparedStatement = null;
            n = 0;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                preparedStatement.setString(1, operableTrigger.getKey().getName());
                preparedStatement.setString(2, operableTrigger.getKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getJobKey().getName());
                preparedStatement.setString(4, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(5, operableTrigger.getDescription());
                if (operableTrigger.getNextFireTime() != null) {
                    preparedStatement.setBigDecimal(6, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
                } else {
                    preparedStatement.setBigDecimal(6, null);
                }
                long l = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(7, new BigDecimal(String.valueOf(l)));
                preparedStatement.setString(8, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(9, string2);
                preparedStatement.setBigDecimal(10, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l2 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l2 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(11, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(12, operableTrigger.getCalendarName());
                preparedStatement.setInt(13, operableTrigger.getMisfireInstruction());
                this.setBytes(preparedStatement, 14, byteArrayOutputStream);
                preparedStatement.setInt(15, operableTrigger.getPriority());
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.insertBlobTrigger(connection, operableTrigger);
                    break block9;
                }
                triggerPersistenceDelegate.insertExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertBlobTrigger(Connection connection, OperableTrigger operableTrigger) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(operableTrigger);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}BLOB_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES({1}, ?, ?, ?)"));
            preparedStatement.setString(1, operableTrigger.getKey().getName());
            preparedStatement.setString(2, operableTrigger.getKey().getGroup());
            preparedStatement.setBinaryStream(3, (InputStream)byteArrayInputStream, byArray.length);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement;
        block10: {
            boolean bl = operableTrigger.getJobDataMap().isDirty();
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (bl && operableTrigger.getJobDataMap().size() > 0) {
                byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            }
            preparedStatement = null;
            n = 0;
            try {
                preparedStatement = bl ? connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?")) : connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, operableTrigger.getJobKey().getName());
                preparedStatement.setString(2, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getDescription());
                long l = -1L;
                if (operableTrigger.getNextFireTime() != null) {
                    l = operableTrigger.getNextFireTime().getTime();
                }
                preparedStatement.setBigDecimal(4, new BigDecimal(String.valueOf(l)));
                long l2 = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l2 = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(5, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(6, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(7, string2);
                preparedStatement.setBigDecimal(8, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l3 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l3 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(9, new BigDecimal(String.valueOf(l3)));
                preparedStatement.setString(10, operableTrigger.getCalendarName());
                preparedStatement.setInt(11, operableTrigger.getMisfireInstruction());
                preparedStatement.setInt(12, operableTrigger.getPriority());
                if (bl) {
                    this.setBytes(preparedStatement, 13, byteArrayOutputStream);
                    preparedStatement.setString(14, operableTrigger.getKey().getName());
                    preparedStatement.setString(15, operableTrigger.getKey().getGroup());
                } else {
                    preparedStatement.setString(13, operableTrigger.getKey().getName());
                    preparedStatement.setString(14, operableTrigger.getKey().getGroup());
                }
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.updateBlobTrigger(connection, operableTrigger);
                    break block10;
                }
                triggerPersistenceDelegate.updateExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBlobTrigger(Connection connection, OperableTrigger operableTrigger) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(operableTrigger);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.setString(2, operableTrigger.getKey().getName());
            preparedStatement.setString(3, operableTrigger.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerExists(Connection connection, TriggerKey triggerKey) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = false;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerState(Connection connection, TriggerKey triggerKey, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerStateFromOtherStates(Connection connection, TriggerKey triggerKey, String string, String string2, String string3, String string4) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            preparedStatement.setString(4, string2);
            preparedStatement.setString(5, string3);
            preparedStatement.setString(6, string4);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerGroupStateFromOtherStates(Connection connection, GroupMatcher<TriggerKey> groupMatcher, String string, String string2, String string3, String string4) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, this.toSqlLikeClause(groupMatcher));
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string3);
            preparedStatement.setString(5, string4);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerStateFromOtherState(Connection connection, TriggerKey triggerKey, String string, String string2) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, triggerKey.getName());
            preparedStatement.setString(3, triggerKey.getGroup());
            preparedStatement.setString(4, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerGroupStateFromOtherState(Connection connection, GroupMatcher<TriggerKey> groupMatcher, String string, String string2) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, this.toSqlLikeClause(groupMatcher));
            preparedStatement.setString(3, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerStatesForJob(Connection connection, JobKey jobKey, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, jobKey.getName());
            preparedStatement.setString(3, jobKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTriggerStatesForJobFromOtherState(Connection connection, JobKey jobKey, String string, String string2) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?"));
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, jobKey.getName());
            preparedStatement.setString(3, jobKey.getGroup());
            preparedStatement.setString(4, string2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteBlobTrigger(Connection connection, TriggerKey triggerKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteTrigger(Connection connection, TriggerKey triggerKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        this.deleteTriggerExtension(connection, triggerKey);
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    protected void deleteTriggerExtension(Connection connection, TriggerKey triggerKey) throws SQLException {
        for (TriggerPersistenceDelegate triggerPersistenceDelegate : this.triggerPersistenceDelegates) {
            if (triggerPersistenceDelegate.deleteExtendedTriggerProperties(connection, triggerKey) <= 0) continue;
            return;
        }
        this.deleteBlobTrigger(connection, triggerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNumTriggersForJob(Connection connection, JobKey jobKey) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            int n;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, jobKey.getName());
                preparedStatement.setString(2, jobKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return n;
        }
        int n = 0;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public JobDetail selectJobForTrigger(Connection connection, ClassLoadHelper classLoadHelper, TriggerKey triggerKey) throws ClassNotFoundException, SQLException {
        return this.selectJobForTrigger(connection, classLoadHelper, triggerKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobDetail selectJobForTrigger(Connection connection, ClassLoadHelper classLoadHelper, TriggerKey triggerKey, boolean bl) throws ClassNotFoundException, SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            JobDetailImpl jobDetailImpl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.JOB_CLASS_NAME, J.REQUESTS_RECOVERY FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.SCHED_NAME = {1} AND J.SCHED_NAME = {1} AND T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP"));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                JobDetailImpl jobDetailImpl2 = new JobDetailImpl();
                jobDetailImpl2.setName(resultSet.getString(1));
                jobDetailImpl2.setGroup(resultSet.getString(2));
                jobDetailImpl2.setDurability(this.getBoolean(resultSet, 3));
                if (bl) {
                    jobDetailImpl2.setJobClass(classLoadHelper.loadClass(resultSet.getString(4), Job.class));
                }
                jobDetailImpl2.setRequestsRecovery(this.getBoolean(resultSet, 5));
                jobDetailImpl = jobDetailImpl2;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return jobDetailImpl;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No job for trigger '" + triggerKey + "'.");
        }
        JobDetail jobDetail = null;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return jobDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> selectTriggersForJob(Connection connection, JobKey jobKey) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        LinkedList<OperableTrigger> linkedList = new LinkedList<OperableTrigger>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                OperableTrigger operableTrigger = this.selectTrigger(connection, TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (operableTrigger == null) continue;
                linkedList.add(operableTrigger);
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> selectTriggersForCalendar(Connection connection, String string) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        LinkedList<OperableTrigger> linkedList = new LinkedList<OperableTrigger>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList.add(this.selectTrigger(connection, TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP"))));
            }
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperableTrigger selectTrigger(Connection connection, TriggerKey triggerKey) throws SQLException, ClassNotFoundException, IOException, JobPersistenceException {
        String string;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object = null;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString("JOB_NAME");
                String string2 = resultSet.getString("JOB_GROUP");
                String string3 = resultSet.getString("DESCRIPTION");
                long l = resultSet.getLong("NEXT_FIRE_TIME");
                long l2 = resultSet.getLong("PREV_FIRE_TIME");
                String string4 = resultSet.getString("TRIGGER_TYPE");
                long l3 = resultSet.getLong("START_TIME");
                long l4 = resultSet.getLong("END_TIME");
                String string5 = resultSet.getString("CALENDAR_NAME");
                int n = resultSet.getInt("MISFIRE_INSTR");
                int n2 = resultSet.getInt("PRIORITY");
                Map map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                Date date = null;
                if (l > 0L) {
                    date = new Date(l);
                }
                Date date2 = null;
                if (l2 > 0L) {
                    date2 = new Date(l2);
                }
                Date date3 = new Date(l3);
                Date date4 = null;
                if (l4 > 0L) {
                    date4 = new Date(l4);
                }
                if (string4.equals("BLOB")) {
                    resultSet.close();
                    resultSet = null;
                    preparedStatement.close();
                    preparedStatement = null;
                    preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}BLOB_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    preparedStatement.setString(1, triggerKey.getName());
                    preparedStatement.setString(2, triggerKey.getGroup());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        object = (OperableTrigger)this.getObjectFromBlob(resultSet, "BLOB_DATA");
                    }
                } else {
                    TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(string4);
                    if (triggerPersistenceDelegate == null) {
                        throw new JobPersistenceException("No TriggerPersistenceDelegate for trigger discriminator type: " + string4);
                    }
                    TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle = null;
                    try {
                        triggerPropertyBundle = triggerPersistenceDelegate.loadExtendedTriggerProperties(connection, triggerKey);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (this.isTriggerStillPresent(preparedStatement)) {
                            throw illegalStateException;
                        }
                        OperableTrigger operableTrigger = null;
                        StdJDBCDelegate.closeResultSet(resultSet);
                        StdJDBCDelegate.closeStatement(preparedStatement);
                        return operableTrigger;
                    }
                    TriggerBuilder<?> triggerBuilder = TriggerBuilder.newTrigger().withDescription(string3).withPriority(n2).startAt(date3).endAt(date4).withIdentity(triggerKey).modifiedByCalendar(string5).withSchedule(triggerPropertyBundle.getScheduleBuilder()).forJob(JobKey.jobKey(string, string2));
                    if (null != map) {
                        triggerBuilder.usingJobData(new JobDataMap(map));
                    }
                    object = (OperableTrigger)triggerBuilder.build();
                    object.setMisfireInstruction(n);
                    object.setNextFireTime(date);
                    object.setPreviousFireTime(date2);
                    this.setTriggerStateProperties((OperableTrigger)object, triggerPropertyBundle);
                }
            }
            string = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTriggerStillPresent(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            StdJDBCDelegate.closeResultSet(resultSet);
        }
    }

    private void setTriggerStateProperties(OperableTrigger operableTrigger, TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle) throws JobPersistenceException {
        if (triggerPropertyBundle.getStatePropertyNames() == null) {
            return;
        }
        Util.setBeanProps(operableTrigger, triggerPropertyBundle.getStatePropertyNames(), triggerPropertyBundle.getStatePropertyValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobDataMap selectTriggerJobDataMap(Connection connection, String string, String string2) throws SQLException, ClassNotFoundException, IOException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            JobDataMap jobDataMap;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT JOB_DATA FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                Map map = null;
                map = this.canUseProperties() ? this.getMapFromProperties(resultSet) : (Map)this.getObjectFromBlob(resultSet, "JOB_DATA");
                resultSet.close();
                preparedStatement.close();
                if (null == map) break block2;
                jobDataMap = new JobDataMap(map);
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return jobDataMap;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return new JobDataMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String selectTriggerState(Connection connection, TriggerKey triggerKey) throws SQLException {
        String string;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = null;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            string2 = resultSet.next() ? resultSet.getString("TRIGGER_STATE") : "DELETED";
            string = string2.intern();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerStatus selectTriggerStatus(Connection connection, TriggerKey triggerKey) throws SQLException {
        String string;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object = null;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString("TRIGGER_STATE");
                long l = resultSet.getLong("NEXT_FIRE_TIME");
                String string2 = resultSet.getString("JOB_NAME");
                String string3 = resultSet.getString("JOB_GROUP");
                Date date = null;
                if (l > 0L) {
                    date = new Date(l);
                }
                object = new TriggerStatus(string, date);
                ((TriggerStatus)object).setKey(triggerKey);
                ((TriggerStatus)object).setJobKey(JobKey.jobKey(string2, string3));
            }
            string = object;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNumTriggers(Connection connection) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> selectTriggerGroups(Connection connection) throws SQLException {
        LinkedList<String> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            while (resultSet.next()) {
                linkedList2.add(resultSet.getString(1));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> selectTriggerGroups(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws SQLException {
        LinkedList<String> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            resultSet = preparedStatement.executeQuery();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            while (resultSet.next()) {
                linkedList2.add(resultSet.getString(1));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TriggerKey> selectTriggersInGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws SQLException {
        HashSet<TriggerKey> hashSet;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this.isMatcherEquals(groupMatcher)) {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, this.toSqlEqualsClause(groupMatcher));
            } else {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
                preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            }
            resultSet = preparedStatement.executeQuery();
            HashSet<TriggerKey> hashSet2 = new HashSet<TriggerKey>();
            while (resultSet.next()) {
                hashSet2.add(TriggerKey.triggerKey(resultSet.getString(1), resultSet.getString(2)));
            }
            hashSet = hashSet2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertPausedTriggerGroup(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}PAUSED_TRIGGER_GRPS (SCHED_NAME, TRIGGER_GROUP) VALUES({1}, ?)"));
            preparedStatement.setString(1, string);
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deletePausedTriggerGroup(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, string);
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deletePausedTriggerGroup(Connection connection, GroupMatcher<TriggerKey> groupMatcher) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP LIKE ?"));
            preparedStatement.setString(1, this.toSqlLikeClause(groupMatcher));
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAllPausedTriggerGroups(Connection connection) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTriggerGroupPaused(Connection connection, String string) throws SQLException {
        boolean bl;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistingTriggerGroup(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = resultSet.getInt(1) > 0;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertCalendar(Connection connection, String string, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeObject(calendar);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (SCHED_NAME, CALENDAR_NAME, CALENDAR)  VALUES({1}, ?, ?)"));
            preparedStatement.setString(1, string);
            this.setBytes(preparedStatement, 2, byteArrayOutputStream);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateCalendar(Connection connection, String string, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeObject(calendar);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            this.setBytes(preparedStatement, 1, byteArrayOutputStream);
            preparedStatement.setString(2, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean calendarExists(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = false;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calendar selectCalendar(Connection connection, String string) throws ClassNotFoundException, IOException, SQLException {
        Calendar calendar;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.rtp("SELECT * FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?");
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            Calendar calendar2 = null;
            if (resultSet.next()) {
                calendar2 = (Calendar)this.getObjectFromBlob(resultSet, "CALENDAR");
            }
            if (null == calendar2) {
                this.logger.warn("Couldn't find calendar with name '" + string + "'.");
            }
            calendar = calendar2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean calendarIsReferenced(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            boolean bl;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return bl;
        }
        boolean bl = false;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteCalendar(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectNumCalendars(Connection connection) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n2 = 0;
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> selectCalendars(Connection connection) throws SQLException {
        LinkedList<String> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            while (resultSet.next()) {
                linkedList2.add(resultSet.getString(1));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long selectNextFireTime(Connection connection) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            long l;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0"));
                preparedStatement.setString(1, "WAITING");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                l = resultSet.getLong("ALIAS_NXT_FR_TM");
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return l;
        }
        long l = 0L;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerKey selectTriggerForFireTime(Connection connection, long l) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            TriggerKey triggerKey;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?"));
                preparedStatement.setString(1, "WAITING");
                preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(l)));
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                triggerKey = new TriggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP"));
            }
            catch (Throwable throwable) {
                StdJDBCDelegate.closeResultSet(resultSet);
                StdJDBCDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            return triggerKey;
        }
        TriggerKey triggerKey = null;
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return triggerKey;
    }

    @Override
    public List<TriggerKey> selectTriggerToAcquire(Connection connection, long l, long l2) throws SQLException {
        return this.selectTriggerToAcquire(connection, l, l2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectTriggerToAcquire(Connection connection, long l, long l2, int n) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LinkedList<TriggerKey> linkedList2 = new LinkedList<TriggerKey>();
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME <= ? AND (MISFIRE_INSTR = -1 OR (MISFIRE_INSTR != -1 AND NEXT_FIRE_TIME >= ?)) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            if (n < 1) {
                n = 1;
            }
            preparedStatement.setMaxRows(n);
            preparedStatement.setFetchSize(n);
            preparedStatement.setString(1, "WAITING");
            preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(l)));
            preparedStatement.setBigDecimal(3, new BigDecimal(String.valueOf(l2)));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next() && linkedList2.size() <= n) {
                linkedList2.add(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertFiredTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}FIRED_TRIGGERS (SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, INSTANCE_NAME, FIRED_TIME, SCHED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_NONCONCURRENT, REQUESTS_RECOVERY, PRIORITY) VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            preparedStatement.setString(1, operableTrigger.getFireInstanceId());
            preparedStatement.setString(2, operableTrigger.getKey().getName());
            preparedStatement.setString(3, operableTrigger.getKey().getGroup());
            preparedStatement.setString(4, this.instanceId);
            preparedStatement.setBigDecimal(5, new BigDecimal(String.valueOf(System.currentTimeMillis())));
            preparedStatement.setBigDecimal(6, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
            preparedStatement.setString(7, string);
            if (jobDetail != null) {
                preparedStatement.setString(8, operableTrigger.getJobKey().getName());
                preparedStatement.setString(9, operableTrigger.getJobKey().getGroup());
                this.setBoolean(preparedStatement, 10, jobDetail.isConcurrentExectionDisallowed());
                this.setBoolean(preparedStatement, 11, jobDetail.requestsRecovery());
            } else {
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
                this.setBoolean(preparedStatement, 10, false);
                this.setBoolean(preparedStatement, 11, false);
            }
            preparedStatement.setInt(12, operableTrigger.getPriority());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateFiredTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}FIRED_TRIGGERS SET INSTANCE_NAME = ?, FIRED_TIME = ?, SCHED_TIME = ?, STATE = ?, JOB_NAME = ?, JOB_GROUP = ?, IS_NONCONCURRENT = ?, REQUESTS_RECOVERY = ? WHERE SCHED_NAME = {1} AND ENTRY_ID = ?"));
            preparedStatement.setString(1, this.instanceId);
            preparedStatement.setBigDecimal(2, new BigDecimal(String.valueOf(System.currentTimeMillis())));
            preparedStatement.setBigDecimal(3, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
            preparedStatement.setString(4, string);
            if (jobDetail != null) {
                preparedStatement.setString(5, operableTrigger.getJobKey().getName());
                preparedStatement.setString(6, operableTrigger.getJobKey().getGroup());
                this.setBoolean(preparedStatement, 7, jobDetail.isConcurrentExectionDisallowed());
                this.setBoolean(preparedStatement, 8, jobDetail.requestsRecovery());
            } else {
                preparedStatement.setString(5, null);
                preparedStatement.setString(6, null);
                this.setBoolean(preparedStatement, 7, false);
                this.setBoolean(preparedStatement, 8, false);
            }
            preparedStatement.setString(9, operableTrigger.getFireInstanceId());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FiredTriggerRecord> selectFiredTriggerRecords(Connection connection, String string, String string2) throws SQLException {
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<LinkedList<FiredTriggerRecord>> linkedList2 = new LinkedList<LinkedList<FiredTriggerRecord>>();
            if (string != null) {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
            } else {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList = new FiredTriggerRecord();
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setPriority(resultSet.getInt("PRIORITY"));
                ((FiredTriggerRecord)((Object)linkedList)).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)((Object)linkedList)).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)((Object)linkedList)).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)((Object)linkedList)).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                linkedList2.add(linkedList);
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FiredTriggerRecord> selectFiredTriggerRecordsByJob(Connection connection, String string, String string2) throws SQLException {
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<LinkedList<FiredTriggerRecord>> linkedList2 = new LinkedList<LinkedList<FiredTriggerRecord>>();
            if (string != null) {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
            } else {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_GROUP = ?"));
                preparedStatement.setString(1, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList = new FiredTriggerRecord();
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setPriority(resultSet.getInt("PRIORITY"));
                ((FiredTriggerRecord)((Object)linkedList)).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)((Object)linkedList)).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)((Object)linkedList)).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)((Object)linkedList)).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                linkedList2.add(linkedList);
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FiredTriggerRecord> selectInstancesFiredTriggerRecords(Connection connection, String string) throws SQLException {
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<LinkedList<FiredTriggerRecord>> linkedList2 = new LinkedList<LinkedList<FiredTriggerRecord>>();
            preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList = new FiredTriggerRecord();
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceId(resultSet.getString("ENTRY_ID"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireInstanceState(resultSet.getString("STATE"));
                ((FiredTriggerRecord)((Object)linkedList)).setFireTimestamp(resultSet.getLong("FIRED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setScheduleTimestamp(resultSet.getLong("SCHED_TIME"));
                ((FiredTriggerRecord)((Object)linkedList)).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((FiredTriggerRecord)((Object)linkedList)).setTriggerKey(TriggerKey.triggerKey(resultSet.getString("TRIGGER_NAME"), resultSet.getString("TRIGGER_GROUP")));
                if (!((FiredTriggerRecord)((Object)linkedList)).getFireInstanceState().equals("ACQUIRED")) {
                    ((FiredTriggerRecord)((Object)linkedList)).setJobDisallowsConcurrentExecution(this.getBoolean(resultSet, "IS_NONCONCURRENT"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobRequestsRecovery(resultSet.getBoolean("REQUESTS_RECOVERY"));
                    ((FiredTriggerRecord)((Object)linkedList)).setJobKey(JobKey.jobKey(resultSet.getString("JOB_NAME"), resultSet.getString("JOB_GROUP")));
                }
                ((FiredTriggerRecord)((Object)linkedList)).setPriority(resultSet.getInt("PRIORITY"));
                linkedList2.add(linkedList);
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> selectFiredTriggerInstanceNames(Connection connection) throws SQLException {
        HashSet<String> hashSet;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            HashSet<String> hashSet2 = new HashSet<String>();
            preparedStatement = connection.prepareStatement(this.rtp("SELECT DISTINCT INSTANCE_NAME FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashSet2.add(resultSet.getString("INSTANCE_NAME"));
            }
            hashSet = hashSet2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteFiredTrigger(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND ENTRY_ID = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectJobExecutionCount(Connection connection, JobKey jobKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobKey.getName());
            preparedStatement.setString(2, jobKey.getGroup());
            resultSet = preparedStatement.executeQuery();
            n = resultSet.next() ? resultSet.getInt(1) : 0;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertSchedulerState(Connection connection, String string, long l, long l2) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}SCHEDULER_STATE (SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL) VALUES({1}, ?, ?, ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.setLong(3, l2);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteSchedulerState(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("DELETE FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setString(1, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateSchedulerState(Connection connection, String string, long l) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}SCHEDULER_STATE SET LAST_CHECKIN_TIME = ? WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerStateRecord> selectSchedulerStateRecords(Connection connection, String string) throws SQLException {
        LinkedList<SchedulerStateRecord> linkedList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            LinkedList<LinkedList<SchedulerStateRecord>> linkedList2 = new LinkedList<LinkedList<SchedulerStateRecord>>();
            if (string != null) {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1} AND INSTANCE_NAME = ?"));
                preparedStatement.setString(1, string);
            } else {
                preparedStatement = connection.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE SCHED_NAME = {1}"));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                linkedList = new SchedulerStateRecord();
                ((SchedulerStateRecord)((Object)linkedList)).setSchedulerInstanceId(resultSet.getString("INSTANCE_NAME"));
                ((SchedulerStateRecord)((Object)linkedList)).setCheckinTimestamp(resultSet.getLong("LAST_CHECKIN_TIME"));
                ((SchedulerStateRecord)((Object)linkedList)).setCheckinInterval(resultSet.getLong("CHECKIN_INTERVAL"));
                linkedList2.add(linkedList);
            }
            linkedList = linkedList2;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return linkedList;
    }

    protected final String rtp(String string) {
        return Util.rtp(string, this.tablePrefix, this.getSchedulerNameLiteral());
    }

    protected String getSchedulerNameLiteral() {
        if (this.schedNameLiteral == null) {
            this.schedNameLiteral = "'" + this.schedName + "'";
        }
        return this.schedNameLiteral;
    }

    protected ByteArrayOutputStream serializeObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (null != object) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        return byteArrayOutputStream;
    }

    protected ByteArrayOutputStream serializeJobData(JobDataMap jobDataMap) throws IOException {
        if (this.canUseProperties()) {
            return this.serializeProperties(jobDataMap);
        }
        try {
            return this.serializeObject(jobDataMap);
        }
        catch (NotSerializableException notSerializableException) {
            throw new NotSerializableException("Unable to serialize JobDataMap for insertion into database because the value of property '" + this.getKeyOfNonSerializableValue(jobDataMap) + "' is not serializable: " + notSerializableException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getKeyOfNonSerializableValue(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = this.serializeObject(entry.getValue());
            }
            catch (IOException iOException) {
                Object obj = entry.getKey();
                return obj;
            }
            finally {
                if (byteArrayOutputStream == null) continue;
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private ByteArrayOutputStream serializeProperties(JobDataMap jobDataMap) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (null != jobDataMap) {
            Properties properties = this.convertToProperty(jobDataMap.getWrappedMap());
            properties.store(byteArrayOutputStream, "");
        }
        return byteArrayOutputStream;
    }

    protected Map<?, ?> convertFromProperty(Properties properties) throws IOException {
        return new HashMap<Object, Object>(properties);
    }

    protected Properties convertToProperty(Map<?, ?> map) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string;
            Object obj = entry.getKey();
            String string2 = string = entry.getValue() == null ? "" : entry.getValue();
            if (!(obj instanceof String)) {
                throw new IOException("JobDataMap keys/values must be Strings when the 'useProperties' property is set.  offending Key: " + obj);
            }
            if (!(string instanceof String)) {
                throw new IOException("JobDataMap values must be Strings when the 'useProperties' property is set.  Key of offending value: " + obj);
            }
            properties.put(obj, string);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        InputStream inputStream;
        Object object = null;
        Blob blob = resultSet.getBlob(string);
        if (!(blob == null || blob.length() == 0L || null == (inputStream = blob.getBinaryStream()) || inputStream instanceof ByteArrayInputStream && ((ByteArrayInputStream)inputStream).available() == 0)) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                object = objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        return object;
    }

    protected Object getJobDataFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            Blob blob = resultSet.getBlob(string);
            if (blob != null) {
                InputStream inputStream = blob.getBinaryStream();
                return inputStream;
            }
            return null;
        }
        return this.getObjectFromBlob(resultSet, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> selectPausedTriggerGroups(Connection connection) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            preparedStatement = connection.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE SCHED_NAME = {1}"));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("TRIGGER_GROUP");
                hashSet.add(object);
            }
            object = hashSet;
        }
        catch (Throwable throwable) {
            StdJDBCDelegate.closeResultSet(resultSet);
            StdJDBCDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        StdJDBCDelegate.closeResultSet(resultSet);
        StdJDBCDelegate.closeStatement(preparedStatement);
        return object;
    }

    protected static void closeResultSet(ResultSet resultSet) {
        if (null != resultSet) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected static void closeStatement(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void setBoolean(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        preparedStatement.setBoolean(n, bl);
    }

    protected boolean getBoolean(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getBoolean(string);
    }

    protected boolean getBoolean(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getBoolean(n);
    }

    protected void setBytes(PreparedStatement preparedStatement, int n, ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        preparedStatement.setBytes(n, byteArrayOutputStream == null ? new byte[]{} : byteArrayOutputStream.toByteArray());
    }
}

