/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.io.Serializable;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.utils.ClassUtils;

public class JobDetailImpl
implements Cloneable,
Serializable,
JobDetail {
    private static final long serialVersionUID = -6069784757781506897L;
    private String name;
    private String group = "DEFAULT";
    private String description;
    private Class<? extends Job> jobClass;
    private JobDataMap jobDataMap;
    private boolean durability = false;
    private boolean shouldRecover = false;
    private transient JobKey key = null;

    public JobDetailImpl() {
    }

    public JobDetailImpl(String string, Class<? extends Job> clazz) {
        this(string, null, clazz);
    }

    public JobDetailImpl(String string, String string2, Class<? extends Job> clazz) {
        this.setName(string);
        this.setGroup(string2);
        this.setJobClass(clazz);
    }

    public JobDetailImpl(String string, String string2, Class<? extends Job> clazz, boolean bl, boolean bl2) {
        this.setName(string);
        this.setGroup(string2);
        this.setJobClass(clazz);
        this.setDurability(bl);
        this.setRequestsRecovery(bl2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Job name cannot be empty.");
        }
        this.name = string;
        this.key = null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("Group name cannot be empty.");
        }
        if (string == null) {
            string = "DEFAULT";
        }
        this.group = string;
        this.key = null;
    }

    public String getFullName() {
        return this.group + "." + this.name;
    }

    @Override
    public JobKey getKey() {
        if (this.key == null) {
            if (this.getName() == null) {
                return null;
            }
            this.key = new JobKey(this.getName(), this.getGroup());
        }
        return this.key;
    }

    public void setKey(JobKey jobKey) {
        if (jobKey == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        this.setName(jobKey.getName());
        this.setGroup(jobKey.getGroup());
        this.key = jobKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class<? extends Job> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Job class cannot be null.");
        }
        if (!Job.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Job class must implement the Job interface.");
        }
        this.jobClass = clazz;
    }

    @Override
    public JobDataMap getJobDataMap() {
        if (this.jobDataMap == null) {
            this.jobDataMap = new JobDataMap();
        }
        return this.jobDataMap;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void setDurability(boolean bl) {
        this.durability = bl;
    }

    public void setRequestsRecovery(boolean bl) {
        this.shouldRecover = bl;
    }

    @Override
    public boolean isDurable() {
        return this.durability;
    }

    @Override
    public boolean isPersistJobDataAfterExecution() {
        return ClassUtils.isAnnotationPresent(this.jobClass, PersistJobDataAfterExecution.class);
    }

    @Override
    public boolean isConcurrentExectionDisallowed() {
        return ClassUtils.isAnnotationPresent(this.jobClass, DisallowConcurrentExecution.class);
    }

    @Override
    public boolean requestsRecovery() {
        return this.shouldRecover;
    }

    public String toString() {
        return "JobDetail '" + this.getFullName() + "':  jobClass: '" + (this.getJobClass() == null ? null : this.getJobClass().getName()) + " concurrentExectionDisallowed: " + this.isConcurrentExectionDisallowed() + " persistJobDataAfterExecution: " + this.isPersistJobDataAfterExecution() + " isDurable: " + this.isDurable() + " requestsRecovers: " + this.requestsRecovery();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JobDetail)) {
            return false;
        }
        JobDetail jobDetail = (JobDetail)object;
        if (jobDetail.getKey() == null || this.getKey() == null) {
            return false;
        }
        return jobDetail.getKey().equals(this.getKey());
    }

    public int hashCode() {
        JobKey jobKey = this.getKey();
        return jobKey == null ? 0 : this.getKey().hashCode();
    }

    @Override
    public Object clone() {
        JobDetailImpl jobDetailImpl;
        try {
            jobDetailImpl = (JobDetailImpl)super.clone();
            if (this.jobDataMap != null) {
                jobDetailImpl.jobDataMap = (JobDataMap)this.jobDataMap.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return jobDetailImpl;
    }

    @Override
    public JobBuilder getJobBuilder() {
        JobBuilder jobBuilder = JobBuilder.newJob().ofType(this.getJobClass()).requestRecovery(this.requestsRecovery()).storeDurably(this.isDurable()).usingJobData(this.getJobDataMap()).withDescription(this.getDescription()).withIdentity(this.getKey());
        return jobBuilder;
    }
}

