/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jmx.jboss;

import java.util.Arrays;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.SchedulerException;
import org.quartz.impl.RemoteMBeanScheduler;

public class JBoss4RMIRemoteMBeanScheduler
extends RemoteMBeanScheduler {
    private static final String DEFAULT_PROVIDER_URL = "jnp://localhost:1099";
    private static final String RMI_ADAPTOR_JNDI_NAME = "jmx/rmi/RMIAdaptor";
    private MBeanServerConnection server = null;
    private String providerURL = "jnp://localhost:1099";

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    @Override
    public void initialize() throws SchedulerException {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(this.getContextProperties());
            this.server = (MBeanServerConnection)initialContext.lookup(RMI_ADAPTOR_JNDI_NAME);
        }
        catch (Exception exception) {
            throw new SchedulerException("Failed to lookup JBoss JMX RMI Adaptor.", exception);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    protected Properties getContextProperties() {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        properties.put("java.naming.provider.url", this.providerURL);
        return properties;
    }

    @Override
    protected Object getAttribute(String string) throws SchedulerException {
        try {
            return this.server.getAttribute(this.getSchedulerObjectName(), string);
        }
        catch (Exception exception) {
            throw new SchedulerException("Failed to get Scheduler MBean attribute: " + string, exception);
        }
    }

    @Override
    protected AttributeList getAttributes(String[] stringArray) throws SchedulerException {
        try {
            return this.server.getAttributes(this.getSchedulerObjectName(), stringArray);
        }
        catch (Exception exception) {
            throw new SchedulerException("Failed to get Scheduler MBean attributes: " + Arrays.asList(stringArray), exception);
        }
    }

    @Override
    protected Object invoke(String string, Object[] objectArray, String[] stringArray) throws SchedulerException {
        try {
            return this.server.invoke(this.getSchedulerObjectName(), string, objectArray, stringArray);
        }
        catch (Exception exception) {
            throw new SchedulerException("Failed to invoke Scheduler MBean operation: " + string, exception);
        }
    }
}

