/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public interface Trigger
extends Serializable,
Cloneable,
Comparable<Trigger> {
    public static final long serialVersionUID = -3904243490805975570L;
    public static final int MISFIRE_INSTRUCTION_SMART_POLICY = 0;
    public static final int MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY = -1;
    public static final int DEFAULT_PRIORITY = 5;

    public TriggerKey getKey();

    public JobKey getJobKey();

    public String getDescription();

    public String getCalendarName();

    public JobDataMap getJobDataMap();

    public int getPriority();

    public boolean mayFireAgain();

    public Date getStartTime();

    public Date getEndTime();

    public Date getNextFireTime();

    public Date getPreviousFireTime();

    public Date getFireTimeAfter(Date var1);

    public Date getFinalFireTime();

    public int getMisfireInstruction();

    public TriggerBuilder<? extends Trigger> getTriggerBuilder();

    public ScheduleBuilder<? extends Trigger> getScheduleBuilder();

    public boolean equals(Object var1);

    @Override
    public int compareTo(Trigger var1);

    public static class TriggerTimeComparator
    implements Comparator<Trigger>,
    Serializable {
        private static final long serialVersionUID = -3904243490805975570L;

        public static int compare(Date date, int n, TriggerKey triggerKey, Date date2, int n2, TriggerKey triggerKey2) {
            int n3;
            if (date != null || date2 != null) {
                if (date == null) {
                    return 1;
                }
                if (date2 == null) {
                    return -1;
                }
                if (date.before(date2)) {
                    return -1;
                }
                if (date.after(date2)) {
                    return 1;
                }
            }
            if ((n3 = n2 - n) != 0) {
                return n3;
            }
            return triggerKey.compareTo(triggerKey2);
        }

        @Override
        public int compare(Trigger trigger, Trigger trigger2) {
            return TriggerTimeComparator.compare(trigger.getNextFireTime(), trigger.getPriority(), trigger.getKey(), trigger2.getNextFireTime(), trigger2.getPriority(), trigger2.getKey());
        }
    }

    public static enum CompletedExecutionInstruction {
        NOOP,
        RE_EXECUTE_JOB,
        SET_TRIGGER_COMPLETE,
        DELETE_TRIGGER,
        SET_ALL_JOB_TRIGGERS_COMPLETE,
        SET_TRIGGER_ERROR,
        SET_ALL_JOB_TRIGGERS_ERROR;

    }

    public static enum TriggerState {
        NONE,
        NORMAL,
        PAUSED,
        COMPLETE,
        ERROR,
        BLOCKED;

    }
}

