/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.Type;
import org.hibernate.annotations.common.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;

public class CompoundTypeEnvironment
implements TypeEnvironment {
    private final TypeEnvironment f;
    private final TypeEnvironment g;
    private final int hashCode;

    public static TypeEnvironment create(TypeEnvironment typeEnvironment, TypeEnvironment typeEnvironment2) {
        if (typeEnvironment2 == IdentityTypeEnvironment.INSTANCE) {
            return typeEnvironment;
        }
        if (typeEnvironment == IdentityTypeEnvironment.INSTANCE) {
            return typeEnvironment2;
        }
        return new CompoundTypeEnvironment(typeEnvironment, typeEnvironment2);
    }

    private CompoundTypeEnvironment(TypeEnvironment typeEnvironment, TypeEnvironment typeEnvironment2) {
        this.f = typeEnvironment;
        this.g = typeEnvironment2;
        this.hashCode = this.doHashCode();
    }

    public Type bind(Type type) {
        return this.f.bind(this.g.bind(type));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompoundTypeEnvironment)) {
            return false;
        }
        CompoundTypeEnvironment compoundTypeEnvironment = (CompoundTypeEnvironment)object;
        if (this.differentHashCode(compoundTypeEnvironment)) {
            return false;
        }
        if (!this.f.equals(compoundTypeEnvironment.f)) {
            return false;
        }
        return this.g.equals(compoundTypeEnvironment.g);
    }

    private boolean differentHashCode(CompoundTypeEnvironment compoundTypeEnvironment) {
        return this.hashCode != compoundTypeEnvironment.hashCode;
    }

    private int doHashCode() {
        int n = this.f.hashCode();
        n = 29 * n + this.g.hashCode();
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.f.toString() + "(" + this.g.toString() + ")";
    }
}

