/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events.annotated;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class EventMethod {
    private static final Logger LOG = Log.getLogger(EventMethod.class);
    protected Class<?> pojo;
    protected Method method;
    private boolean hasSession = false;
    private boolean isStreaming = false;
    private Class<?>[] paramTypes;

    private static Object[] dropFirstArg(Object[] objectArray) {
        if (objectArray.length == 1) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return objectArray2;
    }

    public EventMethod(Class<?> clazz, Method method) {
        this.pojo = clazz;
        this.paramTypes = method.getParameterTypes();
        this.method = method;
        this.identifyPresentParamTypes();
    }

    public EventMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            this.pojo = clazz;
            this.paramTypes = classArray;
            this.method = clazz.getMethod(string, classArray);
            this.identifyPresentParamTypes();
        }
        catch (NoSuchMethodException | SecurityException exception) {
            LOG.warn("Cannot use method {}({}): {}", string, classArray, exception.getMessage());
            this.method = null;
        }
    }

    public void call(Object object, Object ... objectArray) {
        if (this.pojo == null || this.method == null) {
            LOG.warn("Cannot execute call: pojo={}, method={}", this.pojo, this.method);
            return;
        }
        if (object == null) {
            LOG.warn("Cannot call {} on null object", this.method);
            return;
        }
        if (objectArray.length > this.paramTypes.length) {
            Object[] objectArray2 = EventMethod.dropFirstArg(objectArray);
            this.call(object, objectArray2);
            return;
        }
        if (objectArray.length < this.paramTypes.length) {
            throw new IllegalArgumentException("Call arguments length [" + objectArray.length + "] must always be greater than or equal to captured args length [" + this.paramTypes.length + "]");
        }
        try {
            this.method.invoke(object, objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            String string = String.format("Cannot call method %s on %s with args: %s", this.method, this.pojo, QuoteUtil.join(objectArray, ","));
            throw new WebSocketException(string, exception);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    protected Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    private void identifyPresentParamTypes() {
        this.hasSession = false;
        this.isStreaming = false;
        if (this.paramTypes == null) {
            return;
        }
        for (Class<?> clazz : this.paramTypes) {
            if (Session.class.isAssignableFrom(clazz)) {
                this.hasSession = true;
            }
            if (!Reader.class.isAssignableFrom(clazz) && !InputStream.class.isAssignableFrom(clazz)) continue;
            this.isStreaming = true;
        }
    }

    public boolean isHasSession() {
        return this.hasSession;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }
}

