/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;

public abstract class WebSocketFrame
implements Frame {
    protected byte finRsvOp;
    protected boolean masked = false;
    protected byte[] mask;
    protected ByteBuffer data;

    public static WebSocketFrame copy(Frame frame) {
        WebSocketFrame webSocketFrame;
        switch (frame.getOpCode()) {
            case 2: {
                webSocketFrame = new BinaryFrame();
                break;
            }
            case 1: {
                webSocketFrame = new TextFrame();
                break;
            }
            case 8: {
                webSocketFrame = new CloseFrame();
                break;
            }
            case 0: {
                webSocketFrame = new ContinuationFrame();
                break;
            }
            case 9: {
                webSocketFrame = new PingFrame();
                break;
            }
            case 10: {
                webSocketFrame = new PongFrame();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot copy frame with opcode " + frame.getOpCode() + " - " + frame);
            }
        }
        webSocketFrame.copyHeaders(frame);
        ByteBuffer byteBuffer = frame.getPayload();
        if (byteBuffer != null) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer2.put(byteBuffer.slice()).flip();
            webSocketFrame.setPayload(byteBuffer2);
        }
        return webSocketFrame;
    }

    protected WebSocketFrame(byte by) {
        this.reset();
        this.setOpCode(by);
    }

    public abstract void assertValid();

    protected void copyHeaders(Frame frame) {
        this.finRsvOp = 0;
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isFin() ? 128 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv1() ? 64 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv2() ? 32 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | (frame.isRsv3() ? 16 : 0));
        this.finRsvOp = (byte)(this.finRsvOp | frame.getOpCode() & 0xF);
        this.masked = frame.isMasked();
        this.mask = (byte[])(this.masked ? frame.getMask() : null);
    }

    protected void copyHeaders(WebSocketFrame webSocketFrame) {
        this.finRsvOp = webSocketFrame.finRsvOp;
        this.masked = webSocketFrame.masked;
        this.mask = null;
        if (webSocketFrame.mask != null) {
            this.mask = Arrays.copyOf(webSocketFrame.mask, webSocketFrame.mask.length);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        if (this.data == null ? webSocketFrame.data != null : !this.data.equals(webSocketFrame.data)) {
            return false;
        }
        if (this.finRsvOp != webSocketFrame.finRsvOp) {
            return false;
        }
        if (!Arrays.equals(this.mask, webSocketFrame.mask)) {
            return false;
        }
        return this.masked == webSocketFrame.masked;
    }

    @Override
    public byte[] getMask() {
        return this.mask;
    }

    @Override
    public final byte getOpCode() {
        return (byte)(this.finRsvOp & 0xF);
    }

    @Override
    public ByteBuffer getPayload() {
        return this.data;
    }

    public String getPayloadAsUTF8() {
        return BufferUtil.toUTF8String(this.getPayload());
    }

    @Override
    public int getPayloadLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.remaining();
    }

    @Override
    public Frame.Type getType() {
        return Frame.Type.from(this.getOpCode());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.data == null ? 0 : this.data.hashCode());
        n2 = 31 * n2 + this.finRsvOp;
        n2 = 31 * n2 + Arrays.hashCode(this.mask);
        return n2;
    }

    @Override
    public boolean hasPayload() {
        return this.data != null && this.data.hasRemaining();
    }

    public abstract boolean isControlFrame();

    public abstract boolean isDataFrame();

    @Override
    public boolean isFin() {
        return (byte)(this.finRsvOp & 0x80) != 0;
    }

    @Override
    public boolean isLast() {
        return this.isFin();
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    @Override
    public boolean isRsv1() {
        return (byte)(this.finRsvOp & 0x40) != 0;
    }

    @Override
    public boolean isRsv2() {
        return (byte)(this.finRsvOp & 0x20) != 0;
    }

    @Override
    public boolean isRsv3() {
        return (byte)(this.finRsvOp & 0x10) != 0;
    }

    public void reset() {
        this.finRsvOp = (byte)-128;
        this.masked = false;
        this.data = null;
        this.mask = null;
    }

    public WebSocketFrame setFin(boolean bl) {
        this.finRsvOp = (byte)(this.finRsvOp & 0x7F | (bl ? 128 : 0));
        return this;
    }

    public Frame setMask(byte[] byArray) {
        this.mask = byArray;
        this.masked = this.mask != null;
        return this;
    }

    public Frame setMasked(boolean bl) {
        this.masked = bl;
        return this;
    }

    protected WebSocketFrame setOpCode(byte by) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xF0 | by & 0xF);
        return this;
    }

    public WebSocketFrame setPayload(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
        return this;
    }

    public WebSocketFrame setRsv1(boolean bl) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xBF | (bl ? 64 : 0));
        return this;
    }

    public WebSocketFrame setRsv2(boolean bl) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xDF | (bl ? 32 : 0));
        return this;
    }

    public WebSocketFrame setRsv3(boolean bl) {
        this.finRsvOp = (byte)(this.finRsvOp & 0xEF | (bl ? 16 : 0));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OpCode.name((byte)(this.finRsvOp & 0xF)));
        stringBuilder.append('[');
        stringBuilder.append("len=").append(this.getPayloadLength());
        stringBuilder.append(",fin=").append((this.finRsvOp & 0x80) != 0);
        stringBuilder.append(",rsv=");
        stringBuilder.append((this.finRsvOp & 0x40) != 0 ? (char)'1' : '.');
        stringBuilder.append((this.finRsvOp & 0x20) != 0 ? (char)'1' : '.');
        stringBuilder.append((this.finRsvOp & 0x10) != 0 ? (char)'1' : '.');
        stringBuilder.append(",masked=").append(this.masked);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

