/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.UpgradeResponseAdapter;

public class ClientUpgradeResponse
extends UpgradeResponseAdapter {
    private List<ExtensionConfig> extensions;

    public ClientUpgradeResponse() {
    }

    public ClientUpgradeResponse(HttpResponse httpResponse) {
        this.setStatusCode(httpResponse.getStatus());
        this.setStatusReason(httpResponse.getReason());
        HttpFields httpFields = httpResponse.getHeaders();
        for (HttpField httpField : httpFields) {
            this.addHeader(httpField.getName(), httpField.getValue());
        }
        HttpField httpField = httpFields.getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (httpField != null) {
            this.extensions = ExtensionConfig.parseList(httpField.getValues());
        }
        this.setAcceptedSubProtocol(httpFields.get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL));
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public void sendForbidden(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported on client implementation");
    }
}

