/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class KeyStoreScanner
extends ContainerLifeCycle
implements Scanner.DiscreteListener {
    private static final Logger LOG = Log.getLogger(KeyStoreScanner.class);
    private final SslContextFactory sslContextFactory;
    private final File keystoreFile;
    private final Scanner _scanner;

    public KeyStoreScanner(SslContextFactory sslContextFactory) {
        Object object;
        this.sslContextFactory = sslContextFactory;
        try {
            object = sslContextFactory.getKeyStoreResource();
            File file = ((Resource)object).getFile();
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("keystore file does not exist");
            }
            if (file.isDirectory()) {
                throw new IllegalArgumentException("expected keystore file not directory");
            }
            if (((Resource)object).getAlias() != null) {
                file = new File(((Resource)object).getAlias());
            }
            this.keystoreFile = file;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Monitored Keystore File: {}", file);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("could not obtain keystore file", iOException);
        }
        object = this.keystoreFile.getParentFile();
        if (!((File)object).exists() || !((File)object).isDirectory()) {
            throw new IllegalArgumentException("error obtaining keystore dir");
        }
        this._scanner = new Scanner();
        this._scanner.setScanDirs(Collections.singletonList(object));
        this._scanner.setScanInterval(1);
        this._scanner.setReportDirs(false);
        this._scanner.setReportExistingFilesOnStartup(false);
        this._scanner.setScanDepth(1);
        this._scanner.addListener(this);
        this.addBean(this._scanner);
    }

    @Override
    public void fileAdded(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("added {}", string);
        }
        if (this.keystoreFile.toPath().toString().equals(string)) {
            this.reload();
        }
    }

    @Override
    public void fileChanged(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("changed {}", string);
        }
        if (this.keystoreFile.toPath().toString().equals(string)) {
            this.reload();
        }
    }

    @Override
    public void fileRemoved(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {}", string);
        }
        if (this.keystoreFile.toPath().toString().equals(string)) {
            this.reload();
        }
    }

    @ManagedOperation(value="Scan for changes in the SSL Keystore", impact="ACTION")
    public void scan() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanning", new Object[0]);
        }
        this._scanner.scan();
        this._scanner.scan();
    }

    @ManagedOperation(value="Reload the SSL Keystore", impact="ACTION")
    public void reload() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reloading keystore file {}", this.keystoreFile);
        }
        try {
            this.sslContextFactory.reload(sslContextFactory -> {});
        }
        catch (Throwable throwable) {
            LOG.warn("Keystore Reload Failed", throwable);
        }
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this._scanner.getScanInterval();
    }

    public void setScanInterval(int n) {
        this._scanner.setScanInterval(n);
    }
}

