/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;

public class StacklessLogging
implements AutoCloseable {
    private final Set<StdErrLog> squelched = new HashSet<StdErrLog>();

    public StacklessLogging(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            StdErrLog stdErrLog;
            Logger logger = Log.getLogger(clazz);
            if (!(logger instanceof StdErrLog) || logger.isDebugEnabled() || (stdErrLog = (StdErrLog)logger).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    public StacklessLogging(Logger ... loggerArray) {
        for (Logger logger : loggerArray) {
            StdErrLog stdErrLog;
            if (!(logger instanceof StdErrLog) || logger.isDebugEnabled() || (stdErrLog = (StdErrLog)logger).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    @Override
    public void close() {
        for (StdErrLog stdErrLog : this.squelched) {
            stdErrLog.setHideStacks(false);
        }
    }
}

