/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.compression;

import java.util.zip.Inflater;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class InflaterPool
extends CompressionPool<Inflater> {
    private final boolean nowrap;

    public InflaterPool(int n, boolean bl) {
        super(n);
        this.nowrap = bl;
    }

    @Override
    protected Inflater newObject() {
        return new Inflater(this.nowrap);
    }

    @Override
    protected void end(Inflater inflater) {
        inflater.end();
    }

    @Override
    protected void reset(Inflater inflater) {
        inflater.reset();
    }

    public static InflaterPool ensurePool(Container container) {
        InflaterPool inflaterPool = container.getBean(InflaterPool.class);
        if (inflaterPool != null) {
            return inflaterPool;
        }
        int n = -1;
        ThreadPool.SizedThreadPool sizedThreadPool = container.getBean(ThreadPool.SizedThreadPool.class);
        if (sizedThreadPool != null) {
            n = sizedThreadPool.getMaxThreads();
        }
        inflaterPool = new InflaterPool(n, true);
        container.addBean(inflaterPool, true);
        return inflaterPool;
    }
}

