/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TypeUtil {
    private static final Logger LOG;
    public static final Class<?>[] NO_ARGS;
    public static final int CR = 13;
    public static final int LF = 10;
    private static final HashMap<String, Class<?>> name2Class;
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;
    private static final List<Function<Class<?>, URI>> LOCATION_METHODS;
    private static final Function<Class<?>, URI> MODULE_LOCATION;

    public static <T> List<T> asList(T[] TArray) {
        if (TArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(TArray);
    }

    public static Class<?> fromName(String string) {
        return name2Class.get(string);
    }

    public static String toName(Class<?> clazz) {
        return class2Name.get(clazz);
    }

    public static String toClassReference(Class<?> clazz) {
        return TypeUtil.toClassReference(clazz.getName());
    }

    public static String toClassReference(String string) {
        return StringUtil.replace(string, '.', '/').concat(".class");
    }

    public static Object valueOf(Class<?> clazz, String string) {
        try {
            if (clazz.equals(String.class)) {
                return string;
            }
            Method method = class2Value.get(clazz);
            if (method != null) {
                return method.invoke(null, string);
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                return Character.valueOf(string.charAt(0));
            }
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
            LOG.ignore(reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            LOG.ignore(invocationTargetException);
        }
        return null;
    }

    public static Object valueOf(String string, String string2) {
        return TypeUtil.valueOf(TypeUtil.fromName(string), string2);
    }

    public static int parseInt(String string, int n, int n2, int n3) throws NumberFormatException {
        int n4 = 0;
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            int n5 = TypeUtil.convertHexDigit((int)c);
            if (n5 < 0 || n5 >= n3) {
                throw new NumberFormatException(string.substring(n, n + n2));
            }
            n4 = n4 * n3 + n5;
        }
        return n4;
    }

    public static int parseInt(byte[] byArray, int n, int n2, int n3) throws NumberFormatException {
        int n4 = 0;
        if (n2 < 0) {
            n2 = byArray.length - n;
        }
        for (int i = 0; i < n2; ++i) {
            char c = (char)(0xFF & byArray[n + i]);
            int n5 = c - 48;
            if (!(n5 >= 0 && n5 < n3 && n5 < 10 || (n5 = 10 + c - 65) >= 10 && n5 < n3)) {
                n5 = 10 + c - 97;
            }
            if (n5 < 0 || n5 >= n3) {
                throw new NumberFormatException(new String(byArray, n, n2));
            }
            n4 = n4 * n3 + n5;
        }
        return n4;
    }

    public static byte[] parseBytes(String string, int n) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)TypeUtil.parseInt(string, i, 2, n);
        }
        return byArray;
    }

    public static String toString(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            int n2 = 0xFF & by;
            int n3 = 48 + n2 / n % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
            n3 = 48 + n2 % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    public static byte convertHexDigit(byte by) {
        byte by2 = (byte)((by & 0x1F) + (by >> 6) * 25 - 16);
        if (by2 < 0 || by2 > 15) {
            throw new NumberFormatException("!hex " + by);
        }
        return by2;
    }

    public static int convertHexDigit(char c) {
        int n = (c & 0x1F) + (c >> 6) * 25 - 16;
        if (n < 0 || n > 15) {
            throw new NumberFormatException("!hex " + c);
        }
        return n;
    }

    public static int convertHexDigit(int n) {
        int n2 = (n & 0x1F) + (n >> 6) * 25 - 16;
        if (n2 < 0 || n2 > 15) {
            throw new NumberFormatException("!hex " + n);
        }
        return n2;
    }

    public static void toHex(byte by, Appendable appendable) {
        try {
            int n = 0xF & (0xF0 & by) >> 4;
            appendable.append((char)((n > 9 ? 55 : 48) + n));
            n = 0xF & by;
            appendable.append((char)((n > 9 ? 55 : 48) + n));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void toHex(int n, Appendable appendable) throws IOException {
        int n2 = 0xF & (0xF0000000 & n) >> 28;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF000000 & n) >> 24;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF00000 & n) >> 20;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF0000 & n) >> 16;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF000 & n) >> 12;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF00 & n) >> 8;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF0 & n) >> 4;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & n;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        Integer.toString(0, 36);
    }

    public static void toHex(long l, Appendable appendable) throws IOException {
        TypeUtil.toHex((int)(l >> 32), appendable);
        TypeUtil.toHex((int)l, appendable);
    }

    public static String toHexString(byte by) {
        return TypeUtil.toHexString(new byte[]{by}, 0, 1);
    }

    public static String toHexString(byte[] byArray) {
        return TypeUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            int n3 = 0xFF & byArray[i];
            int n4 = 48 + n3 / 16 % 16;
            if (n4 > 57) {
                n4 = 65 + (n4 - 48 - 10);
            }
            stringBuilder.append((char)n4);
            n4 = 48 + n3 % 16;
            if (n4 > 57) {
                n4 = 97 + (n4 - 48 - 10);
            }
            stringBuilder.append((char)n4);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
            byArray[i] = (byte)(0xFF & n);
        }
        return byArray;
    }

    public static void dump(Class<?> clazz) {
        System.err.println("Dump: " + clazz);
        TypeUtil.dump(clazz.getClassLoader());
    }

    public static void dump(ClassLoader classLoader) {
        System.err.println("Dump Loaders:");
        while (classLoader != null) {
            System.err.println("  loader " + classLoader);
            classLoader = classLoader.getParent();
        }
    }

    @Deprecated
    public static Object call(Class<?> clazz, String string, Object object, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static Object construct(Class<?> clazz, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static Object construct(Class<?> clazz, Object[] objectArray, Map<String, Object> map) throws InvocationTargetException, NoSuchMethodException {
        throw new UnsupportedOperationException();
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }

    public static boolean isFalse(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        return "false".equalsIgnoreCase(object.toString());
    }

    public static URI getLocationOfClass(Class<?> clazz) {
        for (Function<Class<?>, URI> function : LOCATION_METHODS) {
            try {
                URI uRI = function.apply(clazz);
                if (uRI == null) continue;
                return uRI;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
        return null;
    }

    public static URI getClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, clazz.getClassLoader());
    }

    public static URI getSystemClassLoaderLocation(Class<?> clazz) {
        return TypeUtil.getClassLoaderLocation(clazz, ClassLoader.getSystemClassLoader());
    }

    public static URI getClassLoaderLocation(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            URL uRL;
            String string = TypeUtil.toClassReference(clazz);
            if (classLoader != null && (uRL = classLoader.getResource(string)) != null) {
                int n;
                URI uRI = uRL.toURI();
                String string2 = uRI.toASCIIString();
                if (string2.startsWith("jar:file:") && (n = (string2 = string2.substring(4)).indexOf("!/")) > 0) {
                    return URI.create(string2.substring(0, n));
                }
                return uRI;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getCodeSourceLocation(Class<?> clazz) {
        try {
            URL uRL;
            CodeSource codeSource;
            ProtectionDomain protectionDomain = AccessController.doPrivileged(() -> clazz.getProtectionDomain());
            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                return uRL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URI getModuleLocation(Class<?> clazz) {
        if (MODULE_LOCATION != null) {
            return MODULE_LOCATION.apply(clazz);
        }
        return null;
    }

    static {
        Object object;
        LOG = Log.getLogger(TypeUtil.class);
        NO_ARGS = new Class[0];
        name2Class = new HashMap();
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            object = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", (Class<?>)object));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", (Class<?>)object));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        LOCATION_METHODS = new ArrayList();
        LOCATION_METHODS.add(TypeUtil::getCodeSourceLocation);
        object = null;
        try {
            Class<?> clazz = TypeUtil.class.getClassLoader().loadClass(TypeUtil.class.getPackage().getName() + ".ModuleLocation");
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof Function) {
                object = (Function)obj;
                LOCATION_METHODS.add((Function<Class<?>, URI>)object);
            }
        }
        catch (Throwable throwable) {
            LOG.debug("This JVM Runtime does not support Modules, disabling Jetty internal support", new Object[0]);
        }
        MODULE_LOCATION = object;
        LOCATION_METHODS.add(TypeUtil::getClassLoaderLocation);
        LOCATION_METHODS.add(TypeUtil::getSystemClassLoaderLocation);
    }
}

